/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.dao;

public class InMemoryKey {
    private final InMemoryKey parentKey;
    private final String kind;
    private final String name;

    public InMemoryKey(InMemoryKey parentKey, String kind, String name) {
        if (null == kind) {
            throw new IllegalArgumentException("Kind cannot be null");
        }
        this.parentKey = parentKey;
        this.kind = kind;
        this.name = name;
    }

    public static InMemoryKey of(InMemoryKey parentKey, String kind, String name) {
        return new InMemoryKey(parentKey, kind, name);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof InMemoryKey)) {
            return false;
        }
        InMemoryKey other = (InMemoryKey)obj;
        if (null == this.parentKey) {
            if (null != other.parentKey) {
                return false;
            }
            return this.kind.equals(other.kind) && this.name.equals(other.name);
        }
        return this.parentKey.equals(other.parentKey) && this.kind.equals(other.kind) && this.name.equals(other.name);
    }

    public int hashCode() {
        return (null != this.parentKey ? 961 * this.parentKey.hashCode() : 0) + 31 * this.kind.hashCode() + this.name.hashCode();
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public InMemoryKey getParentKey() {
        return this.parentKey;
    }

    public String toString() {
        return "Key{ parent:" + this.parentKey + ", kind:" + this.kind + ", name:" + this.name + "}";
    }
}

