/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.dao;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.filter.Filter;
import net.sf.mardao.dao.InMemoryKey;
import net.sf.mardao.dao.Supplier;

public class InMemorySupplier
implements Supplier<InMemoryKey, Map<String, Object>, Map<String, Object>, Object> {
    public static final String NAME_PARENT_KEY = "__parentKey";
    public static final String NAME_KEY = "__Key";
    private final Map<String, Map<String, Map<String, Object>>> store = new TreeMap<String, Map<String, Map<String, Object>>>();

    @Override
    public Object beginTransaction() {
        return new Object();
    }

    @Override
    public void commitTransaction(Object tx) {
    }

    @Override
    public void rollbackActiveTransaction(Object tx) {
    }

    @Override
    public int count(Object tx, String kind, InMemoryKey ancestorKey, InMemoryKey simpleKey, Filter ... filters) {
        Collection<Map<String, Object>> filtered = this.filterValues(this.kindStore(kind).values(), new Filter[0]);
        return filtered.size();
    }

    @Override
    public void deleteValue(Object tx, InMemoryKey key) throws IOException {
        this.kindStore(key).remove(key.getName());
    }

    @Override
    public void deleteValues(Object tx, Collection<InMemoryKey> keys) throws IOException {
        for (InMemoryKey key : keys) {
            this.deleteValue(tx, key);
        }
    }

    @Override
    public Map<String, Object> readValue(Object tx, InMemoryKey key) throws IOException {
        return this.kindStore(key).get(key.getName());
    }

    @Override
    public Future<Map<String, Object>> readFuture(final Object tx, final InMemoryKey key) throws IOException {
        FutureTask<Map<String, Object>> task = new FutureTask<Map<String, Object>>(new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                return InMemorySupplier.this.readValue(tx, key);
            }
        });
        new Thread(task).start();
        return task;
    }

    @Override
    public Future<InMemoryKey> writeFuture(final Object tx, final InMemoryKey key, final Map<String, Object> value) throws IOException {
        FutureTask<InMemoryKey> task = new FutureTask<InMemoryKey>(new Callable<InMemoryKey>(){

            @Override
            public InMemoryKey call() throws Exception {
                return InMemorySupplier.this.writeValue(tx, key, value);
            }
        });
        new Thread(task).start();
        return task;
    }

    @Override
    public Collection getCollection(Map<String, Object> value, String column) {
        return (Collection)value.get(column);
    }

    @Override
    public Date getDate(Map<String, Object> value, String column) {
        return (Date)value.get(column);
    }

    @Override
    public Long getLong(Map<String, Object> core, String column) {
        return (Long)core.get(column);
    }

    @Override
    public InMemoryKey getKey(Map<String, Object> value, String column) {
        return (InMemoryKey)value.get(NAME_KEY);
    }

    @Override
    public InMemoryKey getParentKey(Map<String, Object> value, String column) {
        return (InMemoryKey)value.get(NAME_PARENT_KEY);
    }

    @Override
    public String getString(Map<String, Object> core, String column) {
        return (String)core.get(column);
    }

    @Override
    public Integer getInteger(Map<String, Object> core, String column) {
        return (Integer)core.get(column);
    }

    @Override
    public Boolean getBoolean(Map<String, Object> core, String column) {
        return (Boolean)core.get(column);
    }

    @Override
    public Float getFloat(Map<String, Object> core, String column) {
        return (Float)core.get(column);
    }

    @Override
    public ByteBuffer getByteBuffer(Map<String, Object> core, String column) {
        return (ByteBuffer)core.get(column);
    }

    @Override
    public void setCollection(Map<String, Object> value, String column, Collection c) {
        value.put(column, c);
    }

    @Override
    public void setDate(Map<String, Object> value, String column, Date d) {
        value.put(column, d);
    }

    @Override
    public void setLong(Map<String, Object> value, String column, Long l) {
        value.put(column, l);
    }

    @Override
    public void setString(Map<String, Object> value, String column, String s) {
        value.put(column, s);
    }

    @Override
    public void setInteger(Map<String, Object> value, String column, Integer i) {
        value.put(column, i);
    }

    @Override
    public void setBoolean(Map<String, Object> value, String column, Boolean b) {
        value.put(column, b);
    }

    @Override
    public void setFloat(Map<String, Object> value, String column, Float f) {
        value.put(column, f);
    }

    @Override
    public void setByteBuffer(Map<String, Object> value, String column, ByteBuffer b) {
        value.put(column, b);
    }

    @Override
    public Map<String, Object> createWriteValue(InMemoryKey parentKey, String kind, Long id) {
        return this.createWriteValue(parentKey, this.toKey(parentKey, kind, id));
    }

    private Map<String, Object> createWriteValue(InMemoryKey parentKey, InMemoryKey key) {
        TreeMap<String, Object> value = new TreeMap<String, Object>();
        value.put(NAME_KEY, key);
        value.put(NAME_PARENT_KEY, parentKey);
        return value;
    }

    @Override
    public Map<String, Object> createWriteValue(InMemoryKey parentKey, String kind, String id) {
        return this.createWriteValue(parentKey, this.toKey(parentKey, kind, id));
    }

    @Override
    public Iterable<Map<String, Object>> queryIterable(Object tx, String kind, boolean keysOnly, int offset, int limit, InMemoryKey ancestorKey, InMemoryKey simpleKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Filter ... filters) {
        Collection<Map<String, Object>> remaining = this.kindStore(kind).values();
        return this.filterValues(remaining, filters);
    }

    private Collection<Map<String, Object>> filterValues(Collection<Map<String, Object>> values, Filter ... filters) {
        Collection<Map<String, Object>> after = values;
        if (null != filters) {
            for (Filter f : filters) {
                after = new ArrayList<Map<String, Object>>();
                for (Map<String, Object> v : values) {
                    if (!InMemorySupplier.match(v, f)) continue;
                    after.add(v);
                }
                values = after;
                if (after.isEmpty()) break;
            }
        }
        return after;
    }

    @Override
    public Map<String, Object> queryUnique(Object tx, InMemoryKey parentKey, String kind, Filter ... filters) {
        Iterable<Map<String, Object>> iterable = this.queryIterable(tx, kind, false, 0, 1, parentKey, null, null, false, null, false, filters);
        Iterator<Map<String, Object>> iterator = iterable.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public CursorPage<Map<String, Object>> queryPage(Object tx, String kind, boolean keysOnly, int requestedPageSize, InMemoryKey ancestorKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Collection<String> projections, String cursorString, Filter ... filters) {
        CursorPage<Map<String, Object>> page = new CursorPage<Map<String, Object>>();
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        page.setItems(values);
        if (null == cursorString) {
            page.setTotalSize(this.filterValues(this.kindStore(kind).values(), filters).size());
        }
        boolean foundCursor = null == cursorString;
        for (Map.Entry<String, Map<String, Object>> entry : this.kindStore(kind).entrySet()) {
            if (!foundCursor) {
                foundCursor = entry.getKey().toString().equals(cursorString);
                continue;
            }
            if (!InMemorySupplier.matchAll(entry.getValue(), filters)) continue;
            values.add(entry.getValue());
            if (requestedPageSize != values.size()) continue;
            page.setCursorKey(entry.getKey().toString());
            break;
        }
        return page;
    }

    @Override
    public InMemoryKey writeValue(Object tx, InMemoryKey key, Map<String, Object> core) throws IOException {
        if (null == key.getName()) {
            key = InMemoryKey.of(key.getParentKey(), key.getKind(), Long.toString(Math.round(Math.random() * 9.223372036854776E18)));
        }
        this.kindStore(key).put(key.getName(), core);
        return key;
    }

    @Override
    public InMemoryKey toKey(InMemoryKey parentKey, String kind, Long lId) {
        return InMemoryKey.of(parentKey, kind, null != lId ? lId.toString() : null);
    }

    @Override
    public InMemoryKey toKey(InMemoryKey parentKey, String kind, String sId) {
        return InMemoryKey.of(parentKey, kind, sId);
    }

    @Override
    public Long toLongKey(InMemoryKey key) {
        return null != key ? Long.valueOf(Long.parseLong(key.getName())) : null;
    }

    @Override
    public String toStringKey(InMemoryKey key) {
        return null != key ? key.getName() : null;
    }

    @Override
    public InMemoryKey toParentKey(InMemoryKey key) {
        return null != key ? key.getParentKey() : null;
    }

    protected Map<String, Map<String, Object>> kindStore(InMemoryKey key) {
        return this.kindStore(key.getKind());
    }

    protected Map<String, Map<String, Object>> kindStore(String kind) {
        Map<String, Map<String, Object>> ks = this.store.get(kind);
        if (null == ks && null != kind) {
            ks = new TreeMap<String, Map<String, Object>>();
            this.store.put(kind, ks);
        }
        return ks;
    }

    protected static boolean matchAll(Map<String, Object> v, Filter ... filters) {
        if (null == filters) {
            return true;
        }
        for (Filter f : filters) {
            if (InMemorySupplier.match(v, f)) continue;
            return false;
        }
        return true;
    }

    protected static boolean match(Map<String, Object> v, Filter f) {
        Object value = v.get(f.getColumn());
        if (null == f.getOperand()) {
            return null == value;
        }
        switch (f.getOperator()) {
            case EQUALS: {
                return f.getOperand().equals(value);
            }
        }
        throw new UnsupportedOperationException("match " + (Object)((Object)f.getOperator()));
    }
}

