/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.filter;

import net.sf.mardao.core.filter.FilterOperator;

public class Filter {
    private final String column;
    private final FilterOperator operator;
    private final Object operand;

    private Filter(String column, FilterOperator operation, Object operand) {
        this.column = column;
        this.operator = operation;
        this.operand = operand;
    }

    public static Filter equalsFilter(String column, Object operand) {
        return new Filter(column, FilterOperator.EQUALS, operand);
    }

    public static Filter inFilter(String column, Object operand) {
        return new Filter(column, FilterOperator.IN, operand);
    }

    public static Filter greaterThan(String column, Object operand) {
        return new Filter(column, FilterOperator.GREATER_THAN, operand);
    }

    public static Filter greaterThanOrEquals(String column, Object operand) {
        return new Filter(column, FilterOperator.GREATER_THAN_OR_EQUALS, operand);
    }

    public static Filter lessThan(String column, Object operand) {
        return new Filter(column, FilterOperator.LESS_THAN, operand);
    }

    public static Filter notEqualsFilter(String column, Object operand) {
        return new Filter(column, FilterOperator.NOT_EQUALS, operand);
    }

    public String toString() {
        return this.column + " " + (Object)((Object)this.operator) + " " + this.operand;
    }

    public String getColumn() {
        return this.column;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public Object getOperand() {
        return this.operand;
    }
}

