/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.dao;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.filter.Filter;
import net.sf.mardao.dao.AbstractDao;
import net.sf.mardao.dao.DFactoryDao;
import net.sf.mardao.dao.DUserDao;
import net.sf.mardao.dao.DUserMapper;
import net.sf.mardao.dao.InMemorySupplier;
import net.sf.mardao.dao.Supplier;
import net.sf.mardao.dao.TransFunc;
import net.sf.mardao.domain.DFactory;
import net.sf.mardao.domain.DUser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractDaoTest {
    public static final String PRINCIPAL_FIXTURE = "fixture";
    public static final String PRINCIPAL_SET_UP = "setUp";
    protected DUserDao userDao;
    protected DFactoryDao factoryDao;
    protected Supplier supplier;

    @Before
    public void setUp() {
        this.supplier = new InMemorySupplier();
        this.userDao = new DUserDao(this.supplier);
        this.factoryDao = new DFactoryDao(this.supplier);
        AbstractDao.setPrincipalName((String)PRINCIPAL_SET_UP);
    }

    @Test
    public void testCreateGenerateId() throws IOException {
        DUser actual = new DUser();
        actual.setDisplayName("Hello There");
        this.userDao.put(actual);
        Assert.assertNotNull((Object)actual.getId());
        Assert.assertEquals((Object)PRINCIPAL_SET_UP, (Object)actual.getCreatedBy());
        Assert.assertNotNull((Object)actual.getBirthDate());
    }

    @Test
    public void testWriteReadUser() throws IOException {
        Long id = (Long)this.userDao.withCommitTransaction((TransFunc)new TransFunc<Long>(){

            public Long apply() throws IOException {
                DUser entity = new DUser();
                entity.setId(327L);
                entity.setDisplayName("xHjqL\u00e5\u00e4\u00f6123");
                DUser actual = (DUser)AbstractDaoTest.this.userDao.get(Long.valueOf(327L));
                Assert.assertNull((Object)actual);
                return (Long)AbstractDaoTest.this.userDao.put(entity);
            }
        });
        Assert.assertEquals((Object)327L, (Object)id);
        DUser actual = (DUser)this.userDao.withCommitTransaction((TransFunc)new TransFunc<DUser>(){

            public DUser apply() throws IOException {
                return (DUser)AbstractDaoTest.this.userDao.get(Long.valueOf(327L));
            }
        });
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)327L, (Object)actual.getId());
        Assert.assertEquals((Object)"xHjqL\u00e5\u00e4\u00f6123", (Object)actual.getDisplayName());
    }

    @Test
    public void testWriteReadFuture() throws IOException, ExecutionException, InterruptedException {
        DUser entity = new DUser();
        entity.setId(327L);
        entity.setDisplayName("xHjqL\u00e5\u00e4\u00f6123");
        DUser actual = (DUser)this.userDao.get(Long.valueOf(327L));
        Assert.assertNull((Object)actual);
        Future future = this.userDao.putAsync(entity);
        Long id = (Long)future.get();
        Assert.assertEquals((Object)327L, (Object)id);
        Future read = this.userDao.getAsync(null, Long.valueOf(327L));
        actual = (DUser)read.get();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)327L, (Object)actual.getId());
        Assert.assertEquals((Object)"xHjqL\u00e5\u00e4\u00f6123", (Object)actual.getDisplayName());
    }

    @Test
    public void testWriteReadFactory() throws IOException {
        final String name = (String)this.factoryDao.withCommitTransaction((TransFunc)new TransFunc<String>(){

            public String apply() throws IOException {
                DFactory entity = new DFactory();
                entity.setProviderId("mardao");
                String id = (String)((Object)AbstractDaoTest.this.factoryDao.put(entity));
                return id;
            }
        });
        Assert.assertEquals((Object)"mardao", (Object)name);
        this.factoryDao.withRollbackTransaction((TransFunc)new TransFunc<Void>(){

            public Void apply() throws IOException {
                DFactory actual = (DFactory)AbstractDaoTest.this.factoryDao.get((Serializable)((Object)name));
                Assert.assertNotNull((Object)actual);
                Assert.assertEquals((Object)"mardao", (Object)actual.getProviderId());
                return null;
            }
        });
    }

    @Test
    public void testQueryByField() throws IOException {
        this.createQueryFixtures();
        Iterable<DUser> users = this.userDao.queryByDisplayName("mod7_2");
        int count = 0;
        for (DUser u : users) {
            ++count;
            Assert.assertEquals((Object)"mod7_2", (Object)u.getDisplayName());
            Assert.assertEquals((long)2L, (long)(u.getId() % 7L));
        }
        Assert.assertEquals((long)9L, (long)count);
        users = this.userDao.queryByDisplayName(null);
        Assert.assertFalse((boolean)users.iterator().hasNext());
    }

    @Test
    public void testFindUniqueByField() throws IOException {
        this.createQueryFixtures();
        DUser u47 = this.userDao.findByEmail(null);
        Assert.assertNull((Object)u47);
        u47 = this.userDao.findByEmail("user_47@example.com");
        Assert.assertEquals((Object)47L, (Object)u47.getId());
        Assert.assertEquals((Object)"user_47@example.com", (Object)u47.getEmail());
    }

    @Test
    public void testCount() throws IOException {
        this.createQueryFixtures();
        Assert.assertEquals((long)118L, (long)this.userDao.count());
        Assert.assertEquals((long)1L, (long)this.factoryDao.count());
    }

    @Test
    public void testDelete() throws IOException {
        this.createQueryFixtures();
        DUser actual = (DUser)this.userDao.get(Long.valueOf(42L));
        Assert.assertNotNull((Object)actual);
        this.userDao.delete(Long.valueOf(42L));
        actual = (DUser)this.userDao.get(Long.valueOf(42L));
        Assert.assertNull((Object)actual);
        Assert.assertEquals((long)117L, (long)this.userDao.count());
    }

    @Test
    public void testCreated() throws IOException {
        this.createQueryFixtures();
        DUser actual = (DUser)this.userDao.get(Long.valueOf(42L));
        Assert.assertEquals((Object)PRINCIPAL_FIXTURE, (Object)actual.getCreatedBy());
        Assert.assertNotNull((Object)actual.getBirthDate());
    }

    @Test
    public void testAuditInfoCreated() {
        Object actual = this.supplier.createWriteValue(null, "DUser", Long.valueOf(1L));
        Date date = new Date();
        this.userDao.updateAuditInfo(actual, "first", date, "createdBy", "birthDate", null, null);
        Assert.assertEquals((Object)"first", (Object)this.supplier.getString(actual, "createdBy"));
        Assert.assertEquals((Object)date, (Object)this.supplier.getDate(actual, "birthDate"));
        this.userDao.updateAuditInfo(actual, "second", new Date(0L), "createdBy", "birthDate", null, null);
        Assert.assertEquals((Object)"first", (Object)this.supplier.getString(actual, "createdBy"));
        Assert.assertEquals((Object)date, (Object)this.supplier.getDate(actual, "birthDate"));
    }

    @Test
    public void testAuditInfoUpdated() {
        Object actual = this.supplier.createWriteValue(null, "DUser", Long.valueOf(1L));
        Date date = new Date();
        this.userDao.updateAuditInfo(actual, "first", date, null, null, "createdBy", "birthDate");
        Assert.assertEquals((Object)"first", (Object)this.supplier.getString(actual, "createdBy"));
        Assert.assertEquals((Object)date, (Object)this.supplier.getDate(actual, "birthDate"));
        Date date1 = new Date(0L);
        this.userDao.updateAuditInfo(actual, "second", date1, null, null, "createdBy", "birthDate");
        Assert.assertEquals((Object)"second", (Object)this.supplier.getString(actual, "createdBy"));
        Assert.assertEquals((Object)date1, (Object)this.supplier.getDate(actual, "birthDate"));
        this.userDao.updateAuditInfo(actual, null, null, null, null, "createdBy", "birthDate");
        Assert.assertEquals((Object)"second", (Object)this.supplier.getString(actual, "createdBy"));
        Assert.assertEquals((Object)date1, (Object)this.supplier.getDate(actual, "birthDate"));
    }

    @Test
    public void testQueryPage() throws IOException {
        this.createQueryFixtures();
        Filter filter = Filter.equalsFilter((String)DUserMapper.Field.DISPLAYNAME.getFieldName(), (Object)"mod7_3");
        CursorPage firstPage = this.userDao.queryPage(false, 5, null, null, false, null, false, null, null, new Filter[]{filter});
        Assert.assertEquals((Object)9, (Object)firstPage.getTotalSize());
        Assert.assertNotNull((Object)firstPage.getCursorKey());
        Assert.assertEquals((long)5L, (long)firstPage.getItems().size());
        CursorPage secondPage = this.userDao.queryPage(false, 5, null, null, false, null, false, null, firstPage.getCursorKey(), new Filter[]{filter});
        Assert.assertNull((Object)secondPage.getTotalSize());
        Assert.assertNull((Object)secondPage.getCursorKey());
        Assert.assertEquals((long)4L, (long)secondPage.getItems().size());
    }

    protected void createQueryFixtures() throws IOException {
        AbstractDao.setPrincipalName((String)PRINCIPAL_FIXTURE);
        for (int i = 1; i < 60; ++i) {
            DUser u = new DUser();
            u.setId(Long.valueOf(i));
            u.setDisplayName("mod7_" + i % 7);
            u.setEmail("user_" + i + "@example.com");
            this.userDao.put(u);
            u = new DUser();
            u.setId(Long.valueOf(1000 + i));
            u.setDisplayName("user_" + i);
            u.setEmail("user_1000_" + i + "@example.com");
            this.userDao.put(u);
        }
        DFactory f = new DFactory();
        f.setProviderId("facebook");
        this.factoryDao.put(f);
        AbstractDao.setPrincipalName((String)PRINCIPAL_SET_UP);
    }
}

