/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.geo;

import java.util.Set;
import net.sf.mardao.core.geo.DLocation;
import net.sf.mardao.core.geo.Geobox;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoboxTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetHashN() {
        Assert.assertEquals((String)"E, 1 bit", (long)1L, (long)Geobox.getHashIterative((float)120.0f, (float)-45.0f, (int)0));
    }

    @Test
    public void testGetHashNE() {
        Assert.assertEquals((String)"NE, 2 bit", (long)3L, (long)Geobox.getHashIterative((float)120.0f, (float)45.0f, (int)1));
    }

    @Test
    public void testGetHashOrigo() {
        Assert.assertEquals((String)"(0,0), 16 bit", (long)49152L, (long)Geobox.getHashIterative((float)0.0f, (float)0.0f, (int)15));
    }

    @Test
    public void testGetHashNEedge() {
        Assert.assertEquals((String)"(90,180), 16 bit", (long)65535L, (long)Geobox.getHashIterative((float)180.0f, (float)90.0f, (int)15));
    }

    @Test
    public void testGetHashSWedge() {
        Assert.assertEquals((String)"(-90,-180), 16 bit", (long)0L, (long)Geobox.getHashIterative((float)-180.0f, (float)-90.0f, (int)15));
    }

    public void testGetMask() {
    }

    public void testGetHash() {
    }

    @Test
    public void testGetDistance() {
        DLocation P0 = new DLocation(56.34f, 15.05f);
        DLocation P1 = new DLocation(56.387f, 15.05f);
        DLocation P2 = new DLocation(56.3445f, 15.05f);
        DLocation P3 = new DLocation(56.34043f, 15.05f);
        DLocation P4 = new DLocation(56.34001f, 15.05f);
        Assert.assertEquals((double)5232.0, (double)Geobox.distance((DLocation)P0, (DLocation)P1), (double)0.2f);
    }

    @Test
    public void testSize() {
        float lat = 25.18f;
        for (int bits = 10; bits < 25; ++bits) {
            long maskLat;
            long m = maskLat = Geobox.getMask((float)25.18f, (float)90.0f, (int)bits);
            float latMin = 25.18f;
            while (m == maskLat) {
                m = Geobox.getMask((float)(latMin -= 1.0E-5f), (float)90.0f, (int)bits);
            }
            m = maskLat;
            float latMax = 25.18f;
            while (m == maskLat) {
                m = Geobox.getMask((float)(latMax += 1.0E-5f), (float)90.0f, (int)bits);
            }
            DLocation pMin = new DLocation(latMin, 25.18f);
            DLocation pMax = new DLocation(latMax, 25.18f);
            pMin = new DLocation(25.18f, latMin);
            pMax = new DLocation(25.18f, latMax);
        }
    }

    @Test
    public void testTuple() {
        long hash = Geobox.getHash((float)55.603f, (float)13.001f, (int)12);
        Set boxes = Geobox.getTuple((float)55.603f, (float)13.001f, (int)12);
        Assert.assertTrue((String)"TupleContains", (boolean)boxes.contains(hash));
    }
}

