/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.geo;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.mardao.core.geo.DLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geobox {
    public static final int RADIUS = 6378135;
    public static final int D = 40075004;
    static final float[] D_MAJOR = new float[58];
    @Deprecated
    public static final int BITS_10_39km = 10;
    @Deprecated
    public static final int BITS_12_10km = 12;
    @Deprecated
    public static final int BITS_15_1224m = 15;
    @Deprecated
    public static final int BITS_17_307m = 17;
    @Deprecated
    public static final int BITS_18_154m = 18;
    @Deprecated
    public static final int BITS_19_77m = 19;
    @Deprecated
    public static final int BITS_20_39m = 20;
    @Deprecated
    public static final int BITS_22_10m = 22;
    @Deprecated
    public static final int BITS_23_53dm = 23;
    @Deprecated
    public static final int BITS_24_32dm = 24;
    public static final int BITS_0_40075004m = 0;
    public static final int BITS_1_20037502m = 1;
    public static final int BITS_2_10018751m = 2;
    public static final int BITS_3_5009375m = 3;
    public static final int BITS_4_2504687m = 4;
    public static final int BITS_5_1252343m = 5;
    public static final int BITS_6_626171m = 6;
    public static final int BITS_7_313085m = 7;
    public static final int BITS_8_156542m = 8;
    public static final int BITS_9_78271m = 9;
    public static final int BITS_10_39135m = 10;
    public static final int BITS_11_19567m = 11;
    public static final int BITS_12_9783m = 12;
    public static final int BITS_13_4891m = 13;
    public static final int BITS_14_2445m = 14;
    public static final int BITS_15_1222m = 15;
    public static final int BITS_16_611m = 16;
    public static final int BITS_17_305m = 17;
    public static final int BITS_18_152m = 18;
    public static final int BITS_19_76m = 19;
    public static final int BITS_20_38m = 20;
    public static final int BITS_21_19m = 21;
    public static final int BITS_22_9m = 22;
    public static final int BITS_23_4m = 23;
    public static final int BITS_24_2m = 24;
    public static final int BITS_25_1m = 25;
    public static final int BITS_26_0m = 26;

    public static long getMask(float x, float base, int bits) {
        return (long)Math.floor((x + base) / (2.0f * base) * (float)(1 << bits - 1));
    }

    public static long getHash(float lat, float lng, int bits) {
        if (bits <= 0) {
            throw new IllegalArgumentException("bits must be greater than zero");
        }
        if (29 < bits) {
            throw new IllegalArgumentException("bits must not be greater than 29");
        }
        long precision = (long)bits << 59;
        long mLat = Geobox.getMask(lat, 90.0f, bits);
        long mLng = Geobox.getMask(lng, 180.0f, bits + 1);
        long hash = precision | mLat << 30 | mLng;
        return hash;
    }

    public static Set<Long> getTuple(float lat, float lng, int bits) {
        if (bits <= 0) {
            throw new IllegalArgumentException("bits must be greater than zero");
        }
        if (29 < bits) {
            throw new IllegalArgumentException("bits must not be greater than 29");
        }
        long precision = (long)bits << 59;
        long mLat = Geobox.getMask(lat, 90.0f, bits);
        long mLng = Geobox.getMask(lng, 180.0f, bits + 1);
        TreeSet<Long> tuple = new TreeSet<Long>();
        boolean i = false;
        for (int y = -1; y < 2; ++y) {
            for (int x = -1; x < 2; ++x) {
                tuple.add(precision | mLat + (long)y << 30 | mLng + (long)x);
            }
        }
        return tuple;
    }

    protected static long getHashRecursive(float major, float minor, int bit, float dMajor, float dMinor) {
        long hash = major < 0.0f ? 0L : 1L << bit;
        float dM = dMajor / 2.0f;
        long tail = 0L;
        if (0 < bit) {
            tail = Geobox.getHashRecursive(minor, major + (major < 0.0f ? dM : -dM), bit - 1, dMinor, dM);
        }
        return hash | tail;
    }

    protected static long getHashIterative(float major, float minor, int bits) {
        long hash = 0L;
        int b = bits;
        int i = 0;
        while (0 <= b) {
            float temp = minor;
            if (major < 0.0f) {
                minor = major + D_MAJOR[i + 1];
            } else {
                hash |= 1L << b;
                minor = major - D_MAJOR[i + 1];
            }
            major = temp;
            --b;
            ++i;
        }
        return hash;
    }

    public static long getCell(float lat, float lng, int precision) {
        return Geobox.getCell(lat, lng, 4 * precision, 90.0f, 180.0f);
    }

    private static long getCell(float lat, float lng, int bit, float dy, float dx) {
        long my;
        long mx;
        float nLat = lat;
        float nLng = lng;
        if (lng < 0.0f) {
            mx = 0L;
            nLng = lng + dx / 2.0f;
        } else {
            mx = 1 << bit - 2;
            nLng = lng - dx / 2.0f;
        }
        if (lat < 0.0f) {
            my = 0L;
            nLat = lat + dy / 2.0f;
        } else {
            my = 1 << bit - 1;
            nLat = lat - dy / 2.0f;
        }
        long sub = 2 < bit ? Geobox.getCell(nLat, nLng, bit - 2, dy / 2.0f, dx / 2.0f) : 0L;
        long returnValue = my + mx + sub;
        return returnValue;
    }

    private static double roundSlicedown(double coord, double slice) {
        double remainder = coord % slice;
        if (remainder == Double.NaN) {
            return coord;
        }
        if (coord > 0.0) {
            return coord - remainder + slice;
        }
        return coord - remainder;
    }

    private static double[] computeTuple(double lat, double lng, int resolution, double slice) {
        double adjustedLat = Geobox.roundSlicedown(lat, slice *= Math.pow(10.0, -resolution));
        double adjustedLng = Geobox.roundSlicedown(lng, slice);
        return new double[]{adjustedLat, adjustedLng - slice, adjustedLat - slice, adjustedLng};
    }

    private static String formatTuple(double[] values, int resolution) {
        StringBuffer s = new StringBuffer();
        String format = String.format("%%.%df", resolution);
        for (int i = 0; i < values.length; ++i) {
            s.append(String.format(format, values[i]).replace(',', '.'));
            if (i >= values.length - 1) continue;
            s.append("|");
        }
        return s.toString();
    }

    public static String compute(double lat, double lng, int resolution, int slice) {
        return Geobox.formatTuple(Geobox.computeTuple(lat, lng, resolution, slice), resolution);
    }

    public static List<String> computeSet(double lat, double lng, int resolution, double slice) {
        double[] primaryBox = Geobox.computeTuple(lat, lng, resolution, slice);
        slice *= Math.pow(10.0, -resolution);
        ArrayList<String> set = new ArrayList<String>();
        for (int i = -1; i < 2; ++i) {
            double latDelta = slice * (double)i;
            for (int j = -1; j < 2; ++j) {
                double lngDelta = slice * (double)j;
                double[] adjustedBox = new double[]{primaryBox[0] + latDelta, primaryBox[1] + lngDelta, primaryBox[2] + latDelta, primaryBox[3] + lngDelta};
                set.add(Geobox.formatTuple(adjustedBox, resolution));
            }
        }
        return set;
    }

    public static double distance(DLocation p1, DLocation p2) {
        double p1lat = Math.toRadians(p1.getLatitude());
        double p1lon = Math.toRadians(p1.getLongitude());
        double p2lat = Math.toRadians(p2.getLatitude());
        double p2lon = Math.toRadians(p2.getLongitude());
        return Geobox.distance(p1lat, p1lon, p2lat, p2lon);
    }

    public static double makeDoubleInRange(double d) {
        double result = d;
        if (d > 1.0) {
            result = 1.0;
        } else if (d < -1.0) {
            result = -1.0;
        }
        return result;
    }

    public static int getCellSize(int bits) {
        return 40075004 >> bits;
    }

    public static double getCellSize(int bits, double latitude) {
        return Math.cos(latitude) * (double)Geobox.getCellSize(bits);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 27; ++i) {
            System.out.println(String.format("/** %d bits gives a box of %dm at the Equator */\npublic static final int BITS_%d_%dm = %d;\n", i, Geobox.getCellSize(i), i, Geobox.getCellSize(i), i));
        }
    }

    public static double distance(double p1lat, double p1lon, double p2lat, double p2lon) {
        return 6378135.0 * Math.acos(Geobox.makeDoubleInRange(Math.sin(p1lat) * Math.sin(p2lat) + Math.cos(p1lat) * Math.cos(p2lat) * Math.cos(p2lon - p1lon)));
    }

    static {
        double deg = 180.0;
        for (int i = 0; i < D_MAJOR.length; ++i) {
            Geobox.D_MAJOR[i] = (float)deg;
            deg /= 2.0;
        }
    }
}

