/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core;

import java.io.Serializable;
import net.sf.mardao.core.dao.Dao;

public class Filter {
    private final String column;
    private final Object operation;
    private final Object operand;

    public Filter(String column, Object operation, Object operand) {
        this.column = column;
        this.operation = operation;
        this.operand = operand;
    }

    public String toString() {
        return this.column + this.operation + this.operand;
    }

    public String getColumn() {
        return this.column;
    }

    public Object getOperation() {
        return this.operation;
    }

    public Object getOperand() {
        return this.operand;
    }

    public String getToken(String key) {
        return ":" + key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Foreign<T, ID extends Serializable>
    extends Filter {
        private final Dao<T, ID> foreignDao;
        private final Filter foreignExpression;

        public Foreign(String column, String operation, Dao<T, ID> foreignDao, Filter foreignExpression) {
            super(column, operation, foreignExpression);
            this.foreignExpression = foreignExpression;
            this.foreignDao = foreignDao;
        }

        public Dao<T, ID> getForeignDao() {
            return this.foreignDao;
        }

        public Filter getForeignExpression() {
            return this.foreignExpression;
        }

        @Override
        public Object getOperand() {
            return this.foreignExpression.getOperand();
        }

        @Override
        public String getToken(String key) {
            if (!this.foreignDao.getColumnNames().contains(this.foreignExpression.getColumn())) {
                throw new IllegalArgumentException("No such " + this.foreignDao.getTableName() + " column " + this.foreignExpression.getColumn());
            }
            StringBuffer sql = new StringBuffer("(SELECT ");
            sql.append(this.foreignDao.getPrimaryKeyColumnName());
            sql.append(" FROM ");
            sql.append(this.foreignDao.getTableName());
            sql.append(" WHERE ");
            sql.append(this.foreignExpression.getColumn());
            sql.append(this.foreignExpression.getOperation());
            sql.append(this.foreignExpression.getToken(key));
            sql.append(')');
            return sql.toString();
        }
    }

    public static class IN
    extends Filter {
        public IN(String column, Object operand) {
            super(column, " IN ", operand);
        }

        public String getToken(String key) {
            return "(:" + key + ")";
        }
    }
}

