/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.dao;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheManager;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.Filter;
import net.sf.mardao.core.dao.CsvConverter;
import net.sf.mardao.core.dao.Dao;
import net.sf.mardao.core.geo.DLocation;
import net.sf.mardao.core.geo.Geobox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaoImpl<T, ID extends Serializable, P extends Serializable, CT, E, C extends Serializable>
implements Dao<T, ID>,
CsvConverter<T> {
    public static final String PRINCIPAL_NAME_ANONYMOUS = "[ANONYMOUS]";
    public static final String COLUMN_NAME_GEOBOXES_DEFAULT = "geoboxes";
    protected static final Logger LOG = LoggerFactory.getLogger(DaoImpl.class);
    protected static final String AUDIT_CURSOR_PREFIX = "audit-";
    private Collection<Integer> boxBits = Arrays.asList(18, 15, 12);
    private static final ThreadLocal<String> principalName = new ThreadLocal();
    protected final Class<T> persistentClass;
    protected final Class<ID> simpleIdClass;
    protected DaoImpl mardaoParentDao;
    protected static final Runnable RUNNABLE_VOID = new Runnable(){

        public void run() {
        }
    };
    protected boolean memCacheAll = false;
    protected boolean memCacheEntities = false;
    private static Cache memCache = null;
    private static Map memCacheConfig = Collections.EMPTY_MAP;
    protected boolean populateTotalSize = true;

    protected List<String> getBasicColumnNames() {
        return Collections.EMPTY_LIST;
    }

    protected List<String> getManyToOneColumnNames() {
        return Collections.EMPTY_LIST;
    }

    protected DaoImpl getManyToOneDao(String columnName) {
        return null;
    }

    protected DaoImpl(Class<T> domainType, Class<ID> simpleIdType) {
        this.persistentClass = domainType;
        this.simpleIdClass = simpleIdType;
    }

    @Override
    public String getTableName() {
        return this.persistentClass.getSimpleName();
    }

    protected abstract int doDelete(Object var1, Iterable<ID> var2);

    protected abstract int doDelete(Iterable<T> var1);

    protected abstract T doFindByPrimaryKey(Object var1, ID var2);

    protected abstract Future<?> doFindByPrimaryKeyForFuture(Object var1, ID var2);

    protected abstract Future<List<C>> doPersistCoreForFuture(Iterable<E> var1);

    protected abstract Future<?> doPersistCoreForFuture(E var1);

    protected abstract Iterable<T> doQueryByPrimaryKeys(Object var1, Iterable<ID> var2);

    protected abstract T findUniqueBy(Filter ... var1);

    protected abstract ID findUniqueKeyBy(Filter ... var1);

    protected abstract Collection<C> persistCore(Iterable<E> var1);

    protected abstract CursorPage<T, ID> queryPage(boolean var1, int var2, Object var3, Object var4, String var5, boolean var6, String var7, boolean var8, String var9, Filter ... var10);

    protected abstract Iterable<T> queryIterable(boolean var1, int var2, int var3, Object var4, Object var5, String var6, boolean var7, String var8, boolean var9, Filter ... var10);

    protected abstract Iterable<ID> queryIterableKeys(int var1, int var2, Object var3, Object var4, String var5, boolean var6, String var7, boolean var8, Filter ... var9);

    protected abstract ID coreToSimpleKey(E var1);

    protected abstract ID coreKeyToSimpleKey(C var1);

    protected abstract P coreToParentKey(E var1);

    protected abstract P coreKeyToParentKey(C var1);

    protected abstract int count(Object var1, Object var2, Filter ... var3);

    protected abstract E createCore(Object var1);

    protected abstract E createCore(Object var1, ID var2);

    protected abstract C createCoreKey(Object var1, ID var2);

    protected abstract String createMemCacheKey(Object var1, ID var2);

    protected abstract Object getCoreProperty(E var1, String var2, Class var3);

    protected abstract void setCoreProperty(Object var1, String var2, Object var3);

    protected abstract void setDomainStringProperty(T var1, String var2, Map<String, String> var3);

    protected abstract CursorPage<ID, ID> whatsDeleted(Date var1, int var2, String var3);

    @Override
    public T createDomain(Map<String, String> properties) {
        if (null == properties) {
            return null;
        }
        ID simpleKey = this.getSimpleKey(properties);
        Serializable parentKey = (Serializable)this.getParentKey(properties);
        try {
            T domain = this.createDomain(parentKey, simpleKey);
            this.setDomainStringProperty(domain, this.getCreatedByColumnName(), properties);
            this.setDomainStringProperty(domain, this.getCreatedDateColumnName(), properties);
            this.setDomainStringProperty(domain, this.getUpdatedByColumnName(), properties);
            this.setDomainStringProperty(domain, this.getUpdatedDateColumnName(), properties);
            for (String name : this.getColumnNames()) {
                this.setDomainStringProperty(domain, name, properties);
            }
            return domain;
        }
        catch (IllegalAccessException shouldNeverHappen) {
            LOG.error(this.getTableName(), (Throwable)shouldNeverHappen);
        }
        catch (InstantiationException shouldNeverHappen) {
            LOG.error(this.getTableName(), (Throwable)shouldNeverHappen);
        }
        return null;
    }

    public T coreToDomain(E core) {
        if (null == core) {
            return null;
        }
        ID simpleKey = this.coreToSimpleKey(core);
        P parentKey = this.coreToParentKey(core);
        try {
            T domain = this.createDomain(parentKey, simpleKey);
            this.copyCorePropertyToDomain(this.getCreatedByColumnName(), core, domain);
            this.copyCorePropertyToDomain(this.getCreatedDateColumnName(), core, domain);
            this.copyCorePropertyToDomain(this.getUpdatedByColumnName(), core, domain);
            this.copyCorePropertyToDomain(this.getUpdatedDateColumnName(), core, domain);
            for (String name : this.getColumnNames()) {
                this.copyCorePropertyToDomain(name, core, domain);
            }
            return domain;
        }
        catch (IllegalAccessException shouldNeverHappen) {
            LOG.error(this.getTableName(), (Throwable)shouldNeverHappen);
        }
        catch (InstantiationException shouldNeverHappen) {
            LOG.error(this.getTableName(), (Throwable)shouldNeverHappen);
        }
        return null;
    }

    protected Object copyCorePropertyToDomain(String name, E core, T domain) {
        if (null == name) {
            return null;
        }
        Object value = this.getCoreProperty(core, name, this.getColumnClass(name));
        this.setDomainProperty(domain, name, value);
        return value;
    }

    protected Object copyDomainPropertyToCore(String name, T domain, E core) {
        if (null == name) {
            return null;
        }
        Object value = this.getDomainProperty(domain, name);
        this.setCoreProperty(core, name, value);
        return value;
    }

    public T createDomain() throws InstantiationException, IllegalAccessException {
        return this.createDomain(null, null);
    }

    public T createDomain(Object primaryKey) throws InstantiationException, IllegalAccessException {
        Serializable pk = (Serializable)primaryKey;
        P parentKey = this.coreKeyToParentKey(pk);
        ID simpleKey = this.coreKeyToSimpleKey(pk);
        return this.createDomain(parentKey, simpleKey);
    }

    public T createDomain(Object parentKey, ID simpleKey) throws InstantiationException, IllegalAccessException {
        T domain = this.persistentClass.newInstance();
        this.setParentKey(domain, parentKey);
        this.setSimpleKey(domain, simpleKey);
        return domain;
    }

    public E domainToCore(T domain, Date currentDate) {
        if (null == domain) {
            return null;
        }
        Object simpleKey = this.getSimpleKey(domain);
        E core = this.createCore(this.getParentKey(domain), simpleKey);
        String principal = this.getCreatedBy(domain);
        if (null == principal) {
            principal = DaoImpl.getPrincipalName();
            if (null == principal) {
                principal = PRINCIPAL_NAME_ANONYMOUS;
            }
            this._setCreatedBy(domain, principal);
        }
        this.setCoreProperty(core, this.getCreatedByColumnName(), principal);
        Date date = this.getCreatedDate(domain);
        if (null == date || null == simpleKey) {
            date = currentDate;
            this._setCreatedDate(domain, currentDate);
        }
        this.setCoreProperty(core, this.getCreatedDateColumnName(), date);
        principal = DaoImpl.getPrincipalName();
        if (null == principal) {
            principal = PRINCIPAL_NAME_ANONYMOUS;
        }
        this._setUpdatedBy(domain, principal);
        this.setCoreProperty(core, this.getUpdatedByColumnName(), principal);
        this._setUpdatedDate(domain, currentDate);
        this.setCoreProperty(core, this.getUpdatedDateColumnName(), currentDate);
        for (String name : this.getColumnNames()) {
            this.copyDomainPropertyToCore(name, domain, core);
        }
        if (null != this.getGeoLocationColumnName()) {
            this.updateGeoModel(domain, core);
        }
        return core;
    }

    @Override
    public Map<String, Object> getDomainProperties(Object domainObject) {
        if (null == domainObject) {
            return null;
        }
        Object domain = domainObject;
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        Object simpleKey = this.getSimpleKey(domain);
        this.setMapProperty(props, this.getPrimaryKeyColumnName(), simpleKey);
        Object parentKey = this.getParentKey(domain);
        this.setMapProperty(props, this.getParentKeyColumnName(), parentKey);
        for (String col : this.getColumnNames()) {
            Object value = this.getDomainProperty(domain, col);
            this.setMapProperty(props, col, value);
        }
        return props;
    }

    public Collection<Serializable> domainsToPrimaryKeys(Iterable<T> domains) {
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        for (T d : domains) {
            Serializable pk = (Serializable)this.getPrimaryKey(d);
            keys.add(pk);
        }
        return keys;
    }

    public Collection<ID> domainsToSimpleKeys(Iterable<T> domains) {
        ArrayList keys = new ArrayList();
        for (T d : domains) {
            Object simpleKey = this.getSimpleKey(d);
            keys.add(simpleKey);
        }
        return keys;
    }

    public CursorPage<ID, ID> domainPageToSimplePage(CursorPage<T, ID> domainPage) {
        CursorPage idPage = new CursorPage();
        idPage.setCursorKey(domainPage.getCursorKey());
        idPage.setItems(this.domainsToSimpleKeys(domainPage.getItems()));
        idPage.setRequestedPageSize(domainPage.getRequestedPageSize());
        return idPage;
    }

    public void dropTable() {
    }

    public Collection<ID> coresToSimpleKeys(Iterable<E> cores) {
        ArrayList<ID> ids = new ArrayList<ID>();
        for (E core : cores) {
            ID id = this.coreToSimpleKey(core);
            ids.add(id);
        }
        return ids;
    }

    public Collection<ID> coreKeysToSimpleKeys(Iterable<C> cores) {
        ArrayList<ID> ids = new ArrayList<ID>();
        for (Serializable core : cores) {
            ID id = this.coreKeyToSimpleKey(core);
            ids.add(id);
        }
        return ids;
    }

    @Override
    public ID getSimpleKeyByPrimaryKey(Object primaryKey) {
        return this.coreKeyToSimpleKey((Serializable)primaryKey);
    }

    protected final String createMemCacheKeyAll() {
        return String.format("%s.all()", this.getTableName());
    }

    protected final Collection<String> createMemCacheKeys(Object parentKey, Iterable<ID> simpleKeys) {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (Serializable id : simpleKeys) {
            returnValue.add(this.createMemCacheKey(parentKey, id));
        }
        return returnValue;
    }

    protected Object getDomainProperty(T domain, String name) {
        Object value;
        if (name.equals(this.getCreatedByColumnName())) {
            value = this.getCreatedBy(domain);
        } else if (name.equals(this.getCreatedDateColumnName())) {
            value = this.getCreatedDate(domain);
        } else if (name.equals(this.getUpdatedByColumnName())) {
            value = this.getUpdatedBy(domain);
        } else if (name.equals(this.getUpdatedDateColumnName())) {
            value = this.getUpdatedDate(domain);
        } else {
            throw new IllegalArgumentException(String.format("No such property %s for %s", name, this.getTableName()));
        }
        return value;
    }

    @Override
    public Object getParentKey(Map<String, String> properties) {
        String value = properties.get(this.getParentKeyColumnName());
        Class clazz = this.getColumnClass(this.getParentKeyColumnName());
        return DaoImpl.parseProperty(value, clazz);
    }

    @Override
    public ID getSimpleKey(Map<String, String> properties) {
        String value = properties.get(this.getPrimaryKeyColumnName());
        Class clazz = this.getColumnClass(this.getPrimaryKeyColumnName());
        return (ID)((Serializable)DaoImpl.parseProperty(value, clazz));
    }

    @Override
    public Collection<ID> getSimpleKeys(Iterable<T> domains) {
        ArrayList keys = new ArrayList();
        for (T t : domains) {
            keys.add(this.getSimpleKey(t));
        }
        return keys;
    }

    protected static Cache getMemCache() {
        if (null == memCache) {
            try {
                CacheFactory factory = CacheManager.getInstance().getCacheFactory();
                memCache = factory.createCache(memCacheConfig);
            }
            catch (CacheException ce) {
                LOG.error("Could not create memCache", (Throwable)ce);
            }
        }
        return memCache;
    }

    protected final void updateMemCache(Collection<String> memCacheKeys) {
        LOG.debug("removing cache for {} {}", (Object)memCacheKeys.size(), (Object)this.getTableName());
        if (!memCacheKeys.isEmpty()) {
            if (this.memCacheAll) {
                DaoImpl.getMemCache().remove((Object)this.createMemCacheKeyAll());
            }
            if (this.memCacheEntities) {
                for (String memCacheKey : memCacheKeys) {
                    DaoImpl.getMemCache().remove((Object)memCacheKey);
                }
            }
        }
    }

    protected final void updateMemCache(boolean remove, Map<String, T> domains) {
        if (remove) {
            this.updateMemCache(domains.keySet());
        } else {
            LOG.debug("updating cache for {} {}", (Object)domains.size(), (Object)this.getTableName());
            if (!domains.isEmpty()) {
                if (this.memCacheAll) {
                    DaoImpl.getMemCache().remove((Object)this.createMemCacheKeyAll());
                }
                if (this.memCacheEntities) {
                    DaoImpl.getMemCache().putAll(domains);
                }
            }
        }
    }

    protected final Collection<T> updateMemCache(boolean remove, Iterable<T> domains) {
        if (this.memCacheEntities || this.memCacheAll) {
            ArrayList<T> returnValue = this.memCacheAll ? new ArrayList<T>() : null;
            TreeMap<String, T> toCache = new TreeMap<String, T>();
            for (T domain : domains) {
                Object simpleKey = this.getSimpleKey(domain);
                Object parentKey = this.getParentKey(domain);
                String memCacheKey = this.createMemCacheKey(parentKey, simpleKey);
                toCache.put(memCacheKey, domain);
                if (!this.memCacheAll) continue;
                returnValue.add(domain);
            }
            this.updateMemCache(remove, toCache);
            return returnValue;
        }
        return null;
    }

    protected final Collection<T> updateMemCacheAll(Iterable<T> domains) {
        Collection<T> returnValue = this.updateMemCache(false, domains);
        if (this.memCacheAll && null != returnValue) {
            DaoImpl.getMemCache().put((Object)this.createMemCacheKeyAll(), returnValue);
        }
        return returnValue;
    }

    @Override
    public String getParentKeyColumnName() {
        return null;
    }

    public static String getPrincipalName() {
        return principalName.get();
    }

    @Override
    public void setParentKey(T domain, Object parentKey) {
    }

    @Override
    public String getCreatedBy(T domain) {
        return null;
    }

    @Override
    public String getCreatedByColumnName() {
        return null;
    }

    @Override
    public void _setCreatedBy(T domain, String creator) {
    }

    @Override
    public String getUpdatedBy(T domain) {
        return null;
    }

    @Override
    public String getUpdatedByColumnName() {
        return null;
    }

    @Override
    public void _setUpdatedBy(T domain, String updator) {
    }

    @Override
    public Date getCreatedDate(T domain) {
        return null;
    }

    @Override
    public String getCreatedDateColumnName() {
        return null;
    }

    @Override
    public void _setCreatedDate(T domain, Date date) {
    }

    @Override
    public Date getUpdatedDate(T domain) {
        return null;
    }

    @Override
    public String getUpdatedDateColumnName() {
        return null;
    }

    @Override
    public void _setUpdatedDate(T domain, Date date) {
    }

    protected String getGeoboxesColumnName() {
        return COLUMN_NAME_GEOBOXES_DEFAULT;
    }

    @Override
    public String getGeoLocationColumnName() {
        return null;
    }

    @Override
    public DLocation getGeoLocation(T domain) {
        return null;
    }

    protected void updateGeoModel(T domain, E core) throws IllegalArgumentException {
        DLocation location = this.getGeoLocation(domain);
        ArrayList<Long> geoboxes = new ArrayList<Long>();
        if (null != location) {
            for (int bits : this.boxBits) {
                geoboxes.addAll(Geobox.getTuple(location.getLatitude(), location.getLongitude(), bits));
            }
            this.setCoreProperty(core, this.getGeoboxesColumnName(), geoboxes);
        }
    }

    @Override
    public int count() {
        return this.count(null, null, new Filter[0]);
    }

    @Override
    public int delete(Object parentKey, Iterable<ID> simpleKeys) {
        int count = this.doDelete(parentKey, simpleKeys);
        Collection<String> memCacheKeys = this.createMemCacheKeys(parentKey, simpleKeys);
        this.updateMemCache(memCacheKeys);
        return count;
    }

    public int delete(Iterable<T> domains) {
        int count = this.doDelete(domains);
        this.updateMemCache(true, domains);
        return count;
    }

    @Override
    public boolean delete(Object parentKey, ID simpleKey) {
        int count = this.delete(parentKey, (Iterable<ID>)Arrays.asList(simpleKey));
        return 1 == count;
    }

    @Override
    public boolean delete(ID simpleKey) {
        int count = this.delete((Object)null, (Iterable<ID>)Arrays.asList(simpleKey));
        return 1 == count;
    }

    @Override
    public boolean delete(T domain) {
        int count = this.delete(this.getParentKey(domain), (Iterable<ID>)Arrays.asList(this.getSimpleKey(domain)));
        return 1 == count;
    }

    @Override
    public T findByPrimaryKey(Object parentKey, ID simpleKey) {
        T cached = this.getCachedByPrimaryKey(parentKey, simpleKey);
        if (null != cached) {
            return cached;
        }
        T domain = this.doFindByPrimaryKey(parentKey, simpleKey);
        this.putCachedByPrimaryKey(parentKey, simpleKey, domain);
        return domain;
    }

    @Override
    public T findByPrimaryKey(ID simpleKey) {
        return this.findByPrimaryKey(null, simpleKey);
    }

    @Override
    public T findByPrimaryKey(Object primaryKey) {
        P parentKey = this.coreKeyToParentKey((Serializable)primaryKey);
        ID simpleKey = this.coreKeyToSimpleKey((Serializable)primaryKey);
        return this.findByPrimaryKey(parentKey, simpleKey);
    }

    @Override
    public Future<?> findByPrimaryKeyForFuture(Object parentKey, ID simpleKey) {
        T cached = this.getCachedByPrimaryKey(parentKey, simpleKey);
        if (null != cached) {
            FutureTask<T> task = new FutureTask<T>(RUNNABLE_VOID, cached);
            task.run();
            return task;
        }
        Future<?> future = this.doFindByPrimaryKeyForFuture(parentKey, simpleKey);
        return future;
    }

    @Override
    public Future<?> findByPrimaryKeyForFuture(ID simpleKey) {
        return this.findByPrimaryKeyForFuture(null, simpleKey);
    }

    @Override
    public Future<?> findByPrimaryKeyForFuture(Object primaryKey) {
        P parentKey = this.coreKeyToParentKey((Serializable)primaryKey);
        ID simpleKey = this.coreKeyToSimpleKey((Serializable)primaryKey);
        return this.findByPrimaryKeyForFuture(parentKey, simpleKey);
    }

    protected T getCachedByPrimaryKey(Object parentKey, ID simpleKey) {
        if (this.memCacheEntities && null != simpleKey) {
            String memCacheKey = this.createMemCacheKey(parentKey, simpleKey);
            Object cached = DaoImpl.getMemCache().get((Object)memCacheKey);
            if (null != cached) {
                return (T)cached;
            }
        }
        return null;
    }

    protected String putCachedByPrimaryKey(Object parentKey, ID simpleKey, T domain) {
        if (this.memCacheEntities && null != simpleKey && null != domain) {
            String memCacheKey = this.createMemCacheKey(parentKey, simpleKey);
            DaoImpl.getMemCache().put((Object)memCacheKey, domain);
            return memCacheKey;
        }
        return null;
    }

    @Override
    public T getDomain(Future<?> future) {
        block7: {
            if (null != future) {
                try {
                    Object result = future.get();
                    if (null == result) {
                        return null;
                    }
                    if (this.persistentClass.equals(result.getClass())) {
                        return (T)result;
                    }
                    T domain = this.coreToDomain(result);
                    if (this.memCacheEntities && null != domain) {
                        Object parentKey = this.getParentKey(domain);
                        Object simpleKey = this.getSimpleKey(domain);
                        this.putCachedByPrimaryKey(parentKey, simpleKey, domain);
                    }
                    return domain;
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    if (null != ex.getCause() && "com.google.appengine.api.datastore.EntityNotFoundException".equals(ex.getCause().getClass().getName())) break block7;
                    LOG.warn("Executing", (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Override
    public ID getSimpleKey(Future<?> future) {
        block6: {
            if (null != future) {
                try {
                    Object result = future.get();
                    if (null == result) {
                        return null;
                    }
                    if (this.simpleIdClass.equals(result.getClass())) {
                        return (ID)((Serializable)result);
                    }
                    ID simpleKey = this.coreKeyToSimpleKey((Serializable)result);
                    return simpleKey;
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    if (null != ex.getCause() && "com.google.appengine.api.datastore.EntityNotFoundException".equals(ex.getCause().getClass().getName())) break block6;
                    LOG.warn("Executing", (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Override
    public Collection<ID> getSimpleKeys(Future<List<?>> future) {
        block7: {
            if (null != future) {
                try {
                    List<?> result = future.get();
                    if (null == result) {
                        return null;
                    }
                    List<?> list = result;
                    if (list.isEmpty()) {
                        return list;
                    }
                    Object first = list.get(0);
                    if (this.simpleIdClass.equals(first.getClass())) {
                        return list;
                    }
                    Collection<ID> simpleKeys = this.coreKeysToSimpleKeys(list);
                    return simpleKeys;
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    if (null != ex.getCause() && "com.google.appengine.api.datastore.EntityNotFoundException".equals(ex.getCause().getClass().getName())) break block7;
                    LOG.warn("Executing", (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Override
    public Object getPrimaryKey(Object parentKey, ID simpleKey) {
        return this.createCoreKey(parentKey, simpleKey);
    }

    @Override
    public Collection<ID> persist(Iterable<T> domains) {
        Date currentDate = new Date();
        ArrayList<E> itrbl = new ArrayList<E>();
        for (T d : domains) {
            E core = this.domainToCore(d, currentDate);
            itrbl.add(core);
        }
        Collection<C> keys = this.persistCore(itrbl);
        ArrayList<ID> ids = new ArrayList<ID>(itrbl.size());
        Iterator<T> ds = domains.iterator();
        for (Serializable c : keys) {
            ID simpleKey = this.coreKeyToSimpleKey(c);
            ids.add(simpleKey);
            T d = ds.next();
            if (null != this.getSimpleKey(d)) continue;
            this.setSimpleKey(d, simpleKey);
        }
        this.updateMemCache(false, domains);
        return ids;
    }

    @Override
    public ID persist(T domain) {
        ID ids = this.persist((T)Arrays.asList(domain));
        Serializable id = ids.iterator().hasNext() ? (Serializable)ids.iterator().next() : null;
        return (ID)id;
    }

    @Override
    public Future<?> persistForFuture(T domain) {
        Date currentDate = new Date();
        LOG.debug("persistForFuture {}s", (Object)this.getTableName());
        return this.doPersistCoreForFuture(this.domainToCore(domain, currentDate));
    }

    @Override
    public Future<List<?>> persistForFuture(Iterable<T> domains) {
        Date currentDate = new Date();
        LOG.debug("persistForFuture {}s", (Object)this.getTableName());
        ArrayList<E> entities = new ArrayList<E>();
        for (T d : domains) {
            entities.add(this.domainToCore(d, currentDate));
        }
        Future<List<?>> f = this.doPersistCoreForFuture((E)entities);
        return f;
    }

    @Override
    public Iterable<T> queryAll() {
        Collection<T> returnValue = null;
        if (this.memCacheAll) {
            returnValue = (Collection)DaoImpl.getMemCache().get((Object)this.createMemCacheKeyAll());
        }
        if (null == returnValue) {
            returnValue = this.queryIterable(false, 0, -1, null, null, null, false, null, false, new Filter[0]);
            if (this.memCacheAll) {
                returnValue = this.updateMemCacheAll(returnValue);
                LOG.debug("Queried {} entities for {}.queryAll()", (Object)returnValue.size(), (Object)this.getTableName());
            } else {
                LOG.debug("Queried entities for {}.queryAll()", (Object)this.getTableName());
            }
        } else {
            LOG.debug("Fetched {} entities from memCache {}.queryAll()", (Object)returnValue.size(), (Object)this.getTableName());
        }
        return returnValue;
    }

    @Override
    public Iterable<T> queryAll(Object parentKey) {
        Collection ts;
        Iterable<Object> returnValue = null;
        if (this.memCacheAll && null != (ts = (Collection)DaoImpl.getMemCache().get((Object)this.createMemCacheKeyAll()))) {
            ArrayList domains;
            returnValue = domains = new ArrayList();
            for (Object t : ts) {
                if (null != parentKey && !parentKey.equals(this.getParentKey(t))) continue;
                domains.add(t);
            }
        }
        if (null == returnValue) {
            returnValue = this.queryIterable(false, 0, -1, (Serializable)parentKey, null, null, false, null, false, new Filter[0]);
        }
        return returnValue;
    }

    @Override
    public Iterable<T> queryChunk(int offset, int limit, Object ancestorKey, Object primaryKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Filter ... filters) {
        Iterable<T> returnValue = this.queryIterable(false, offset, limit, ancestorKey, primaryKey, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, filters);
        return returnValue;
    }

    @Override
    public Iterable<ID> queryAllKeys() {
        Collection ts;
        Iterable<ID> returnValue = null;
        if (this.memCacheAll && null != (ts = (Collection)DaoImpl.getMemCache().get((Object)this.createMemCacheKeyAll()))) {
            returnValue = this.domainsToSimpleKeys(ts);
        }
        if (null == returnValue) {
            returnValue = this.queryIterableKeys(0, -1, null, null, null, false, null, false, new Filter[0]);
        }
        return returnValue;
    }

    @Override
    public Iterable<ID> queryAllKeys(Object parentKey) {
        Collection ts;
        Iterable returnValue = null;
        if (this.memCacheAll && null != (ts = (Collection)DaoImpl.getMemCache().get((Object)this.createMemCacheKeyAll()))) {
            ArrayList keys;
            returnValue = keys = new ArrayList();
            for (Object t : ts) {
                if (null != parentKey && !parentKey.equals(this.getParentKey(t))) continue;
                Object simpleKey = this.getSimpleKey(t);
                keys.add(simpleKey);
            }
        }
        if (null == returnValue) {
            returnValue = this.queryIterableKeys(0, -1, (Serializable)parentKey, null, null, false, null, false, new Filter[0]);
        }
        return returnValue;
    }

    @Override
    public Iterable<T> queryByPrimaryKeys(Object parentKey, Iterable<ID> simpleKeys) {
        int entitiesCached = 0;
        int entitiesQueried = 0;
        TreeMap entities = new TreeMap();
        TreeSet<Serializable> missing = new TreeSet<Serializable>();
        for (Serializable id : simpleKeys) {
            missing.add(id);
        }
        Collection<String> memCacheKeys = null;
        if (this.memCacheEntities) {
            memCacheKeys = this.createMemCacheKeys(parentKey, missing);
            try {
                Map cached = DaoImpl.getMemCache().getAll(memCacheKeys);
                for (Map.Entry cacheHit : cached.entrySet()) {
                    Object domain = cacheHit.getValue();
                    Object simpleKey = this.getSimpleKey(domain);
                    missing.remove(simpleKey);
                    entities.put(simpleKey, cacheHit.getValue());
                }
                entitiesCached = entities.size();
            }
            catch (CacheException ex) {
                LOG.warn(String.format("Error getting cached %ss", this.getTableName()), (Throwable)ex);
            }
            catch (NullPointerException ifNoCache) {
                this.memCacheEntities = false;
                LOG.warn("Disabling non-functional cache for {}.memCacheEntities", (Object)this.getTableName());
            }
        }
        if (!missing.isEmpty()) {
            Iterable<T> queried = this.doQueryByPrimaryKeys(parentKey, missing);
            HashMap<String, T> toCache = new HashMap<String, T>(missing.size());
            for (T domain : queried) {
                Object simpleKey = this.getSimpleKey(domain);
                entities.put(simpleKey, domain);
                String memCacheKey = this.createMemCacheKey(parentKey, simpleKey);
                toCache.put(memCacheKey, domain);
            }
            this.updateMemCache(false, toCache);
            entitiesQueried = entities.size();
        }
        LOG.debug("cached:{}, queried:{}", (Object)entitiesCached, (Object)entitiesQueried);
        return entities.values();
    }

    @Override
    public CursorPage<T, ID> queryPage(int pageSize, String cursorString) {
        return this.queryPage(false, pageSize, null, null, null, false, null, false, cursorString, new Filter[0]);
    }

    @Override
    public CursorPage<T, ID> queryPage(int pageSize, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, String cursorString) {
        return this.queryPage(false, pageSize, null, null, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, cursorString, new Filter[0]);
    }

    @Override
    public CursorPage<T, ID> queryInGeobox(float lat, float lng, int bits, int pageSize, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, String cursorString, Filter ... filters) {
        if (!this.boxBits.contains(bits)) {
            throw new IllegalArgumentException("Unboxed resolution, hashed are " + this.boxBits);
        }
        long box = Geobox.getHash(lat, lng, bits);
        Filter[] geoFilters = (Filter[])Arrays.copyOf(filters, filters != null ? filters.length + 1 : 1, Filter[].class);
        geoFilters[geoFilters.length - 1] = this.createEqualsFilter(this.getGeoboxesColumnName(), box);
        return this.queryPage(false, pageSize, null, null, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, cursorString, geoFilters);
    }

    @Override
    public Collection<T> findNearest(float lat, float lng, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, int offset, int limit, Filter ... filters) {
        DLocation p = new DLocation(lat, lng);
        int size = offset + (0 < limit ? limit : 10000);
        TreeMap<Double, T> orderedMap = new TreeMap<Double, T>();
        for (int bits : this.boxBits) {
            CursorPage<T, ID> subList = this.queryInGeobox(lat, lng, bits, limit, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, null, filters);
            for (T model : subList.getItems()) {
                double d = Geobox.distance(this.getGeoLocation(model), p);
                orderedMap.put(d, model);
            }
            if (size > orderedMap.size()) continue;
            break;
        }
        Collection values = orderedMap.values();
        Object[] page = Arrays.copyOfRange(values.toArray(), Math.min(offset, values.size()), Math.min(size, values.size()));
        return Arrays.asList(page);
    }

    @Override
    public void update(Iterable<T> domains) {
        this.persist((T)domains);
    }

    @Override
    public void update(T domain) {
        this.persist((T)Arrays.asList(domain));
    }

    public static String escapeCsv(Object s) {
        if (null == s) {
            return null;
        }
        String escaped = s.toString().replaceAll("\\\"", "\"\"");
        String quoted = String.format("\"%s\"", escaped);
        return quoted;
    }

    @Override
    public Map<String, Object> getCsvColumnValues(DaoImpl dao, String[] columns, T domain) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String col : columns) {
            values.put(col, this.getDomainProperty(domain, col));
        }
        return values;
    }

    @Override
    public void writeAsCsv(OutputStream out, String[] columns, CsvConverter<T> converter, Object ancestorKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Filter ... filters) {
        Iterable<T> qi = this.queryIterable(false, 0, -1, ancestorKey, null, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, filters);
        this.writeAsCsv(out, columns, converter, qi);
    }

    @Override
    public void writeAsCsv(OutputStream out, String[] columns, Iterable<T> qi) {
        this.writeAsCsv(out, columns, this, qi);
    }

    @Override
    public void writeAsCsv(OutputStream out, String[] columns, CsvConverter<T> converter, Iterable<T> qi) {
        PrintWriter pw = new PrintWriter(out);
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (String col : columns) {
            if (!(this.getColumnNames().contains(col) || this.getPrimaryKeyColumnName().equals(col) || col.equals(this.getParentKeyColumnName()))) {
                LOG.warn("No such column {}", (Object)col);
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(DaoImpl.escapeCsv(col));
        }
        pw.println(sb.toString());
        LOG.debug(sb.toString());
        for (T domain : qi) {
            sb.setLength(0);
            isFirst = true;
            for (String col : columns) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(DaoImpl.escapeCsv(this.getDomainProperty(domain, col)));
            }
            pw.println(sb.toString());
            LOG.debug(sb.toString());
        }
        pw.flush();
    }

    @Override
    public CursorPage<ID, ID> whatsChanged(Date since, int pageSize, String cursorKey) {
        return this.whatsChanged(null, since, pageSize, cursorKey, new Filter[0]);
    }

    @Override
    public CursorPage<ID, ID> whatsChanged(Object parentKey, Date since, int pageSize, String cursorKey, Filter ... filters) {
        String updatedDateColumnName = this.getUpdatedDateColumnName();
        if (null == updatedDateColumnName) {
            throw new UnsupportedOperationException("Not supported without @UpdatedDate");
        }
        CursorPage<ID, ID> idPage = null;
        String auditCursorKey = cursorKey;
        if (null == cursorKey || !cursorKey.startsWith(AUDIT_CURSOR_PREFIX)) {
            auditCursorKey = null;
            Filter[] allFilters = Arrays.copyOf(filters, (null != filters ? filters.length : 0) + 1);
            allFilters[allFilters.length - 1] = this.createGreaterThanOrEqualFilter(updatedDateColumnName, since);
            CursorPage<T, ID> entityPage = this.queryPage(true, pageSize, parentKey, null, updatedDateColumnName, true, null, false, cursorKey, allFilters);
            idPage = this.domainPageToSimplePage(entityPage);
        }
        if (null == idPage || null == idPage.getCursorKey() || idPage.getItems().size() < pageSize) {
            int remainingSize = null == idPage ? pageSize : pageSize - idPage.getItems().size();
            CursorPage<ID, ID> deletedKeys = this.whatsDeleted(since, remainingSize, auditCursorKey);
            if (null == idPage) {
                idPage = deletedKeys;
            } else {
                idPage.getItems().addAll(deletedKeys.getItems());
                idPage.setCursorKey(deletedKeys.getCursorKey());
            }
        }
        return idPage;
    }

    protected void setDomainProperty(T domain, String name, Object value) {
        if (name.equals(this.getCreatedByColumnName())) {
            this._setCreatedBy(domain, (String)value);
        } else if (name.equals(this.getCreatedDateColumnName())) {
            this._setCreatedDate(domain, (Date)value);
        } else if (name.equals(this.getUpdatedByColumnName())) {
            this._setUpdatedBy(domain, (String)value);
        } else if (name.equals(this.getUpdatedDateColumnName())) {
            this._setUpdatedDate(domain, (Date)value);
        } else {
            throw new IllegalArgumentException(String.format("No such property %s for %s", name, this.getTableName()));
        }
    }

    protected void setMapProperty(Map<String, Object> map, String name, Object value) {
        if (null != map && null != name) {
            map.put(name, value);
        }
    }

    public static Object parseProperty(String value, Class clazz) {
        if (null == value) {
            return null;
        }
        if (Long.class.equals((Object)clazz)) {
            return Long.parseLong(value);
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.parseInt(value);
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.parseShort(value);
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.parseByte(value);
        }
        if (String.class.equals((Object)clazz)) {
            return value;
        }
        if (Date.class.equals((Object)clazz)) {
            long l = Long.parseLong(value);
            return new Date(l);
        }
        throw new UnsupportedOperationException("Unparseable property " + value + " of class " + clazz.getName());
    }

    public void setMardaoParentDao(DaoImpl mardaoParentDao) {
        this.mardaoParentDao = mardaoParentDao;
    }

    public void setBoxBits(Collection<Integer> boxBits) {
        this.boxBits = boxBits;
    }

    public static void setPrincipalName(String name) {
        principalName.set(name);
    }

    public static void setMemCacheConfig(Map memCacheConfig) {
        DaoImpl.memCacheConfig = memCacheConfig;
    }
}

