/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import net.sf.mardao.core.CursorPage;
import net.sf.mardao.core.Filter;
import net.sf.mardao.core.dao.AbstractDatabaseHelper;
import net.sf.mardao.core.dao.CursorIterable;
import net.sf.mardao.core.dao.CursorIterableFactory;
import net.sf.mardao.core.dao.DaoImpl;
import net.sf.mardao.core.geo.DLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeDaoImpl<T, ID extends Serializable>
extends DaoImpl<T, ID, Long, CursorIterable, ContentValues, Long> {
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    protected final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected static final String OPERATION_IN = " IN (%s)";
    protected static AbstractDatabaseHelper databaseHelper;
    protected final SQLiteDatabase.CursorFactory cursorFactory = new CursorIterableFactory(this);
    protected int minLogPriority = 4;
    protected static final Properties DATA_TYPES_DEFAULT;

    protected TypeDaoImpl(Class<T> type, Class<ID> idType) {
        super(type, idType);
        this.debug("<init>", new Object[0]);
    }

    protected void println(int priority, String format, Object ... args) {
        if (this.minLogPriority <= priority) {
            Log.println((int)priority, (String)this.TAG, (String)String.format(format, args));
        }
    }

    protected void printStackTrace(int priority, String message, Throwable t) {
        if (this.minLogPriority <= priority) {
            Log.println((int)priority, (String)this.TAG, (String)message);
            Log.println((int)priority, (String)this.TAG, (String)Log.getStackTraceString((Throwable)t));
        }
    }

    protected final synchronized SQLiteDatabase getDbConnection() {
        return databaseHelper.getDbConnection();
    }

    protected final synchronized void releaseDbConnection() {
    }

    protected static String appendWhereFilters(ArrayList<String> sArgs, Filter ... filters) {
        StringBuffer sb = new StringBuffer();
        String selection = null;
        for (Filter filter : filters) {
            Object operation;
            if (0 < sb.length()) {
                sb.append(" AND ");
            }
            sb.append(filter.getColumn());
            String operand = TypeDaoImpl.buildOperand(filter.getOperand());
            if (OPERATION_IN.equals(filter.getOperation())) {
                operation = String.format(OPERATION_IN, operand);
            } else {
                operation = filter.getOperation();
                sArgs.add(operand);
            }
            sb.append(operation);
            sb.append("?");
            selection = sb.toString();
        }
        return selection;
    }

    protected ID coreToSimpleKey(ContentValues core) {
        if (null == core) {
            return null;
        }
        return (ID)core.getAsLong(this.getPrimaryKeyColumnName());
    }

    protected ID coreKeyToSimpleKey(Long core) {
        return (ID)core;
    }

    protected Long coreToParentKey(ContentValues core) {
        if (null == core) {
            return null;
        }
        return core.getAsLong(this.getParentKeyColumnName());
    }

    protected Long coreKeyToParentKey(Long core) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected int count(Object ancestorKey, Object simpleKey, Filter ... filters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected ContentValues createCore(Object primaryKey) {
        ContentValues core = new ContentValues();
        core.put(this.getPrimaryKeyColumnName(), (Long)primaryKey);
        return core;
    }

    protected ContentValues createCore(Object parentKey, ID simpleKey) {
        return this.createCore(simpleKey);
    }

    protected Long createCoreKey(Object parentKey, ID simpleKey) {
        return (Long)simpleKey;
    }

    public static void putString(String columnName, CursorIterable cursor, ContentValues core) {
        int columnIndex;
        if (null != columnName && -1 < (columnIndex = cursor.getColumnIndex(columnName))) {
            core.put(columnName, cursor.getString(columnIndex));
        }
    }

    public static void putLong(String columnName, CursorIterable cursor, ContentValues core) {
        int columnIndex;
        if (null != columnName && -1 < (columnIndex = cursor.getColumnIndex(columnName))) {
            core.put(columnName, Long.valueOf(cursor.getLong(columnIndex)));
        }
    }

    protected Object getFromCursor(String columnName, CursorIterable cursor) {
        int columnIndex;
        if (null != columnName && -1 < (columnIndex = cursor.getColumnIndex(columnName))) {
            String s;
            Class clazz = this.getColumnClass(columnName);
            if (Double.class.equals((Object)clazz)) {
                return cursor.getDouble(columnIndex);
            }
            if (Float.class.equals((Object)clazz)) {
                return Float.valueOf(cursor.getFloat(columnIndex));
            }
            if (Long.class.equals((Object)clazz)) {
                return cursor.getLong(columnIndex);
            }
            if (Integer.class.equals((Object)clazz)) {
                return cursor.getInt(columnIndex);
            }
            if (Short.class.equals((Object)clazz)) {
                return cursor.getShort(columnIndex);
            }
            if (Byte.class.equals((Object)clazz)) {
                return (byte)cursor.getShort(columnIndex);
            }
            if (Date.class.equals((Object)clazz)) {
                s = cursor.getString(columnIndex);
                try {
                    return SDF.parse(s);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
            if (String.class.equals((Object)clazz)) {
                return cursor.getString(columnIndex);
            }
            if (Boolean.class.equals((Object)clazz)) {
                return 0 != cursor.getShort(columnIndex);
            }
            if (DLocation.class.equals((Object)clazz)) {
                s = cursor.getString(columnIndex);
                String[] latLong = s.split(",");
                return new DLocation(Float.parseFloat(latLong[0]), Float.parseFloat(latLong[1]));
            }
        }
        return null;
    }

    protected void setDomainFromCursor(T domain, String columnName, CursorIterable cursor) {
        Object value = this.getFromCursor(columnName, cursor);
        if (null != value) {
            this.setDomainProperty(domain, columnName, value);
        }
    }

    public T createDomain(CursorIterable cursor) throws InstantiationException, IllegalAccessException {
        if (null == cursor) {
            return null;
        }
        Serializable simpleKey = (Serializable)this.getFromCursor(this.getPrimaryKeyColumnName(), cursor);
        Long parentKey = (Long)this.getFromCursor(this.getParentKeyColumnName(), cursor);
        Object domain = this.createDomain(parentKey, simpleKey);
        this.setDomainFromCursor(domain, this.getCreatedByColumnName(), cursor);
        this.setDomainFromCursor(domain, this.getCreatedDateColumnName(), cursor);
        this.setDomainFromCursor(domain, this.getUpdatedByColumnName(), cursor);
        this.setDomainFromCursor(domain, this.getUpdatedDateColumnName(), cursor);
        for (String name : this.getColumnNames()) {
            this.setDomainFromCursor(domain, name, cursor);
        }
        return (T)domain;
    }

    protected String createMemCacheKey(Object parentKey, ID simpleKey) {
        return String.format("%s.%s.%s", this.getTableName(), parentKey, simpleKey);
    }

    public Filter createEqualsFilter(String columnName, Object value) {
        if (null == value) {
            return new Filter(columnName, (Object)" IS ", (Object)"NULL");
        }
        return new Filter(columnName, (Object)"=", value);
    }

    public Filter createGreaterThanOrEqualFilter(String columnName, Object value) {
        return new Filter(columnName, (Object)">=", value);
    }

    public Filter createInFilter(String fieldName, Collection param) {
        return new Filter.IN(fieldName, (Object)param);
    }

    public int deleteAll() {
        return this.deleteWithConnection(null, null);
    }

    protected int doDelete(Object parentKey, Iterable<ID> simpleKeys) {
        StringBuffer sb = new StringBuffer();
        Iterator<ID> i = simpleKeys.iterator();
        while (i.hasNext()) {
            Serializable id = (Serializable)i.next();
            sb.append(id);
            sb.append(i.hasNext() ? "," : "");
        }
        String whereClause = String.format("%s IN (%s)", this.getPrimaryKeyColumnName(), sb.toString());
        this.debug("delete %s WHERE %s", new Object[]{this.getTableName(), whereClause});
        String[] whereArgs = new String[]{};
        return this.deleteWithConnection(whereClause, whereArgs);
    }

    protected int doDelete(Iterable<T> domains) {
        return this.doDelete(null, this.getSimpleKeys(domains));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable() {
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            dbCon.execSQL(String.format("DROP TABLE IF EXISTS %s", this.getTableName()));
        }
        finally {
            this.releaseDbConnection();
        }
    }

    protected T doFindByPrimaryKey(Object parentKey, ID simpleKey) {
        return this.findUniqueBy(this.createEqualsFilter(this.getPrimaryKeyColumnName(), simpleKey));
    }

    protected Future<?> doFindByPrimaryKeyForFuture(Object parentKey, ID simpleKeys) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Future<List<Long>> doPersistCoreForFuture(Iterable<ContentValues> entities) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Future<?> doPersistCoreForFuture(ContentValues core) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Iterable<T> doQueryByPrimaryKeys(Object parentKey, Iterable<ID> simpleKeys) {
        return this.findBy(this.createInFilter(this.getPrimaryKeyColumnName(), TypeDaoImpl.asList(simpleKeys)));
    }

    protected T findUniqueBy(Filter ... filters) {
        List<T> list = this.findBy(filters);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected ID findUniqueKeyBy(Filter ... filters) {
        Iterable<ID> itrbl = this.queryIterableKeys(0, 1, null, null, null, false, null, false, filters);
        Iterator<ID> itr = itrbl.iterator();
        return (ID)(itr.hasNext() ? (Serializable)itr.next() : null);
    }

    protected Object getCoreProperty(ContentValues core, String name, Class domainPropertyClass) {
        Object value = null;
        if (null != core && null != name && null != (value = core.get(name))) {
            if (DLocation.class.equals((Object)domainPropertyClass)) {
                String latLong = (String)value;
                int commaIndex = latLong.indexOf(44);
                value = new DLocation(Float.parseFloat(latLong.substring(0, commaIndex)), Float.parseFloat(latLong.substring(commaIndex + 1)));
            } else if (Date.class.equals((Object)domainPropertyClass)) {
                try {
                    value = SDF.parse((String)value);
                }
                catch (ParseException ex) {
                    this.error(value.toString(), ex);
                }
            }
        }
        return value;
    }

    public String getKeyString(Object key) {
        return null != key ? key.toString() : null;
    }

    public Object getParentKey(T domain) {
        return null;
    }

    public Object getParentKey(Map<String, String> properties) {
        String value = properties.get(this.getParentKeyColumnName());
        return null != value ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public Object getParentKeyByPrimaryKey(Object primaryKey) {
        return null;
    }

    public Object getPrimaryKey(String keyString) {
        return null != keyString ? Long.valueOf(Long.parseLong(keyString)) : null;
    }

    public Object getPrimaryKey(T domain) {
        return this.getSimpleKey(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Long> persistCore(Iterable<ContentValues> itrbl) {
        ArrayList<Long> ids = new ArrayList<Long>();
        SQLiteDatabase dbCon = this.getDbConnection();
        this.info("Persisting batch of core entities...", new Object[0]);
        try {
            for (ContentValues core : itrbl) {
                ids.add(this.persistCore(core, dbCon));
            }
            this.info("Persted batch of %d.", new Object[]{ids.size()});
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID persist(T domain) {
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            ContentValues core = (ContentValues)this.domainToCore(domain, new Date());
            Long id = this.persistCore(core, dbCon);
            this.setSimpleKey(domain, id);
            this.updateMemCache(false, Arrays.asList(domain));
            Long l = id;
            return (ID)l;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ID> persist(Iterable<T> domains) {
        Date currentDate = new Date();
        ArrayList<Long> ids = new ArrayList<Long>();
        SQLiteDatabase dbCon = this.getDbConnection();
        this.info("Persisting batch of core entities...", new Object[0]);
        try {
            for (T d : domains) {
                ContentValues core = (ContentValues)this.domainToCore(d, currentDate);
                Long id = this.persistCore(core, dbCon);
                this.setSimpleKey(d, id);
                ids.add(id);
            }
            this.info("Persted batch of %d.", new Object[]{ids.size()});
            this.updateMemCache(false, domains);
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    protected CursorPage<T, ID> queryPage(boolean keysOnly, int pageSize, Object ancestorKey, Object primaryKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, String cursorString, Filter ... filters) {
        CursorPage page = new CursorPage();
        int offset = null != cursorString ? Integer.parseInt(cursorString) : 0;
        Iterable itrbl = this.queryIterable(keysOnly, offset, pageSize, ancestorKey, primaryKey, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, filters);
        ArrayList items = new ArrayList();
        for (Object t : itrbl) {
            items.add(t);
        }
        page.setItems(items);
        if (pageSize == items.size()) {
            page.setCursorKey(Integer.toString(offset + pageSize));
        }
        return page;
    }

    protected Iterable<ID> queryIterableKeys(int offset, int limit, Object ancestorKey, Object primaryKey, String primaryOrderBy, boolean primaryIsAscending, String secondaryOrderBy, boolean secondaryIsAscending, Filter ... filters) {
        return this.queryIterable(true, limit, offset, ancestorKey, primaryKey, primaryOrderBy, primaryIsAscending, secondaryOrderBy, secondaryIsAscending, filters);
    }

    protected void setCoreProperty(Object core, String name, Object value) {
        if (null != name) {
            ContentValues cv = (ContentValues)core;
            if (null == value) {
                cv.putNull(name);
                return;
            }
            if (value instanceof DLocation) {
                DLocation location = (DLocation)value;
                cv.put(name, String.format("%f,%f", Float.valueOf(location.getLatitude()), Float.valueOf(location.getLongitude())));
                return;
            }
            if (value instanceof Date) {
                cv.put(name, SDF.format((Date)value));
                return;
            }
            cv.put(name, String.valueOf(value));
        }
    }

    protected CursorPage<ID, ID> whatsDeleted(Date since, int pageSize, String cursorKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Iterable<T> domains) {
        Date now = new Date();
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            for (T t : domains) {
                this.updateByCore((ContentValues)this.domainToCore(t, now), dbCon);
            }
        }
        finally {
            this.releaseDbConnection();
        }
    }

    public void update(T domain) {
        this.updateByCore((ContentValues)this.domainToCore(domain, new Date()));
    }

    protected List<ID> convert(Cursor cursor) {
        ArrayList<Long> returnValue = new ArrayList<Long>();
        if (cursor.moveToFirst()) {
            do {
                returnValue.add(cursor.getLong(0));
            } while (cursor.moveToNext());
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int deleteWithConnection(String whereClause, String[] whereArgs) {
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            int n = dbCon.delete(this.getTableName(), whereClause, whereArgs);
            return n;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    protected List<T> findBy(Filter ... filters) {
        return this.findBy(null, false, -1, 0, null, filters);
    }

    protected List<T> findBy(String orderBy, boolean ascending, int limit, int offset, Long parentKey, Filter ... filters) {
        return TypeDaoImpl.findBy(this, orderBy, ascending, limit, offset, parentKey, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T, ID extends Serializable> List<T> findBy(TypeDaoImpl<T, ID> dao, String orderBy, boolean ascending, int limit, int offset, Long parentKey, Filter ... filters) {
        dao.getDbConnection();
        try {
            CursorIterable cursor = (CursorIterable)TypeDaoImpl.queryBy(dao, false, orderBy, ascending, null, false, limit, offset, filters);
            ArrayList list = TypeDaoImpl.asList(cursor);
            cursor.close();
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            dao.releaseDbConnection();
        }
    }

    public void onCreate(SQLiteDatabase sqldb) {
        String createSql = this.createTable();
        this.info("onCreate() %s", new Object[]{createSql});
        sqldb.execSQL(createSql);
    }

    public void onUpgrade(SQLiteDatabase sqldb, int fromVersion, int toVersion) {
        this.info("onUpgrade(%s) from %d to %d", new Object[]{this.getTableName(), fromVersion, toVersion});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long persistCore(ContentValues core) {
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            Long l = this.persistCore(core, dbCon);
            return l;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    protected Long persistCore(ContentValues core, SQLiteDatabase dbCon) {
        try {
            Long id = dbCon.insertOrThrow(this.getTableName(), null, core);
            this.debug("inserted %s for ID %d", new Object[]{this.getTableName(), id});
            return id;
        }
        catch (SQLiteException e) {
            this.debug("%s updating existing row", new Object[]{e.getMessage()});
            return this.updateByCore(core, dbCon);
        }
    }

    protected Iterable queryIterable(boolean keysOnly, int limit, int offset, Object ancestorKey, Object primaryKey, String orderBy, boolean ascending, String secondaryOrderBy, boolean secondaryIsAscending, Filter ... filters) {
        return (CursorIterable)TypeDaoImpl.queryBy(this, keysOnly, orderBy, ascending, secondaryOrderBy, secondaryIsAscending, limit, offset, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cursor queryBy(TypeDaoImpl dao, boolean keysOnly, String orderBy, boolean ascending, String secondaryOrderBy, boolean secondaryIsAscending, int limit, int offset, Filter ... filters) {
        String orderByClause;
        String[] selectionArgs;
        SQLiteDatabase.CursorFactory factory = keysOnly ? null : dao.cursorFactory;
        String[] columns = new String[]{dao.getPrimaryKeyColumnName()};
        if (!keysOnly) {
            columns = null;
        }
        ArrayList<String> sArgs = new ArrayList<String>();
        String selection = TypeDaoImpl.appendWhereFilters(sArgs, filters);
        String[] stringArray = selectionArgs = sArgs.isEmpty() ? null : sArgs.toArray(new String[sArgs.size()]);
        String string = null != orderBy ? orderBy + (ascending ? " ASC" : " DESC") : (orderByClause = null);
        String limitClause = 0 < limit ? String.valueOf(limit) + (0 < offset ? "," + offset : "") : null;
        SQLiteDatabase dbCon = dao.getDbConnection();
        try {
            Cursor cursor;
            Cursor cursor2 = cursor = dbCon.queryWithFactory(factory, true, dao.getTableName(), columns, selection, selectionArgs, null, null, orderByClause, limitClause);
            return cursor2;
        }
        finally {
            dao.releaseDbConnection();
        }
    }

    private static String buildOperand(Object operand) {
        if (operand instanceof Boolean) {
            return Boolean.TRUE.equals(operand) ? "1" : "0";
        }
        if (operand instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            for (Object object : (Collection)operand) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(TypeDaoImpl.buildOperand(object));
            }
            String returnValue = builder.toString();
            return returnValue;
        }
        return String.valueOf(operand);
    }

    public static ArrayList asList(Iterable itrbl) {
        ArrayList ids = new ArrayList();
        for (Object i : itrbl) {
            ids.add(i);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> updateByCore(Iterable<ContentValues> entities) {
        ArrayList<Long> ids = new ArrayList<Long>();
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            for (ContentValues entity : entities) {
                ids.add(this.updateByCore(entity, dbCon));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long updateByCore(ContentValues entity) {
        SQLiteDatabase dbCon = this.getDbConnection();
        try {
            Long l = this.updateByCore(entity, dbCon);
            return l;
        }
        finally {
            this.releaseDbConnection();
        }
    }

    protected Long updateByCore(ContentValues entity, SQLiteDatabase dbCon) {
        try {
            Long id = entity.getAsLong(this.getPrimaryKeyColumnName());
            String[] whereArgs = new String[]{id.toString()};
            this.debug("updateByCore %s %s", new Object[]{this.getTableName(), entity});
            dbCon.update(this.getTableName(), entity, "_id = ?", whereArgs);
            return id;
        }
        catch (SQLiteException e2) {
            this.error("SQLiteException %s: %s", new Object[]{e2.getMessage(), e2.toString()});
            return -1L;
        }
    }

    protected String createTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(this.getTableName());
        sql.append(" (");
        sql.append("_id INTEGER PRIMARY KEY AUTOINCREMENT");
        this.appendParentKeyColumnDefinition(sql);
        for (String columnName : this.getBasicColumnNames()) {
            sql.append(", ");
            this.appendColumnDefinition(sql, columnName);
        }
        for (String columnName : this.getManyToOneColumnNames()) {
            sql.append(", ");
            this.appendColumnDefinition(sql, columnName);
        }
        this.appendConstraints(sql);
        sql.append(");");
        return sql.toString();
    }

    protected void appendParentKeyColumnDefinition(StringBuffer sql) {
        String columnName = this.getParentKeyColumnName();
        if (null != columnName) {
            sql.append(", ");
            this.appendColumnDefinition(sql, columnName, true);
        }
    }

    protected void appendColumnDefinition(StringBuffer sql, String columnName, boolean isPrimaryKey) {
        sql.append(columnName);
        sql.append(' ');
        String className = this.getColumnClass(columnName).getName();
        String dataType = this.getDataType(className, isPrimaryKey);
        if (null == dataType) {
            dataType = this.getDataType(Long.class.getName());
        }
        sql.append(dataType);
    }

    protected void appendColumnDefinition(StringBuffer sql, String columnName) {
        this.appendColumnDefinition(sql, columnName, false);
    }

    protected void appendConstraints(StringBuffer sql) {
        if (null != this.getParentKeyColumnName()) {
            this.appendConstraint(sql, this.getParentKeyColumnName(), this.mardaoParentDao);
        }
        for (String columnName : this.getManyToOneColumnNames()) {
            this.appendConstraint(sql, columnName, this.getManyToOneDao(columnName));
        }
    }

    protected void appendConstraint(StringBuffer sql, String columnName, DaoImpl foreignDao) {
        sql.append(", ");
        sql.append("CONSTRAINT ");
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append("Fk");
        sql.append(this.getTableName());
        sql.append(columnName);
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append(" FOREIGN KEY (");
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append(columnName);
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append(") REFERENCES ");
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append(foreignDao.getTableName());
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append('(');
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append(foreignDao.getPrimaryKeyColumnName());
        sql.append(this.getDataType("COLUMN_QUOTE"));
        sql.append(')');
    }

    protected String getDataType(String className) {
        return this.getDataType(className, false);
    }

    protected String getDataType(String className, boolean isPrimaryKey) {
        String returnValue = DATA_TYPES_DEFAULT.getProperty(className);
        return returnValue;
    }

    public Object beginTransaction() {
        return databaseHelper.beginTransaction();
    }

    public void commitTransaction(Object transaction) {
        databaseHelper.commitTransaction((SQLiteDatabase)transaction);
    }

    public void rollbackActiveTransaction(Object transaction) {
        SQLiteDatabase t = (SQLiteDatabase)transaction;
        if (null != t && t.isOpen()) {
            databaseHelper.rollbackTransaction(t);
        }
    }

    public static void setDatabaseHelper(AbstractDatabaseHelper databaseHelper) {
        TypeDaoImpl.databaseHelper = databaseHelper;
    }

    static {
        DATA_TYPES_DEFAULT = new Properties();
        DATA_TYPES_DEFAULT.setProperty(Double.class.getName(), "REAL");
        DATA_TYPES_DEFAULT.setProperty(Float.class.getName(), "REAL");
        DATA_TYPES_DEFAULT.setProperty(Long.class.getName(), "INTEGER");
        DATA_TYPES_DEFAULT.setProperty(Integer.class.getName(), "INTEGER");
        DATA_TYPES_DEFAULT.setProperty(Short.class.getName(), "INTEGER");
        DATA_TYPES_DEFAULT.setProperty(Byte.class.getName(), "INTEGER");
        DATA_TYPES_DEFAULT.setProperty(Date.class.getName(), "DATETIME");
        DATA_TYPES_DEFAULT.setProperty(String.class.getName(), "VARCHAR");
        DATA_TYPES_DEFAULT.setProperty(Boolean.class.getName(), "NUMERIC");
        DATA_TYPES_DEFAULT.setProperty(DLocation.class.getName(), "VARCHAR(33)");
        DATA_TYPES_DEFAULT.setProperty("AUTO_INCREMENT", "AUTO_INCREMENT");
        DATA_TYPES_DEFAULT.setProperty("COLUMN_QUOTE", "`");
    }
}

