/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.dao;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import java.util.List;
import net.sf.mardao.core.dao.TypeDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseHelper
extends SQLiteOpenHelper {
    public static final String TAG = AbstractDatabaseHelper.class.getSimpleName();
    public static final String DATABASE_NAME = "mardao";
    private static SQLiteDatabase _db = null;

    protected AbstractDatabaseHelper(Context context, String databaseName) {
        super(context, databaseName, null, 1);
        Log.i((String)TAG, (String)"DatabaseHelper.<init>");
    }

    protected AbstractDatabaseHelper(Context context) {
        this(context, DATABASE_NAME);
    }

    protected SQLiteDatabase beginTransaction() {
        SQLiteDatabase dbCon = this.getDbConnection();
        dbCon.beginTransaction();
        return dbCon;
    }

    protected void commitTransaction(SQLiteDatabase dbCon) {
        if (dbCon.inTransaction()) {
            dbCon.setTransactionSuccessful();
            dbCon.endTransaction();
        }
    }

    protected void rollbackTransaction(SQLiteDatabase dbCon) {
        if (dbCon.inTransaction()) {
            dbCon.endTransaction();
        }
    }

    protected SQLiteDatabase getDbConnection() {
        if (null == _db) {
            _db = this.getWritableDatabase();
        }
        return _db;
    }

    protected void closeDbConnection() {
        if (null != _db) {
            _db.close();
            _db = null;
        }
    }

    public abstract List<TypeDaoImpl<? extends Object, Long>> getDaos();

    public void onCreate(SQLiteDatabase sqld) {
        Log.i((String)TAG, (String)"DatabaseHelper.onCreate()");
        for (TypeDaoImpl<? extends Object, Long> dao : this.getDaos()) {
            dao.onCreate(sqld);
        }
    }

    public void onUpgrade(SQLiteDatabase sqld, int fromVersion, int toVersion) {
        Log.i((String)TAG, (String)"DatabaseHelper.onUpgrade()");
        for (TypeDaoImpl<? extends Object, Long> dao : this.getDaos()) {
            dao.onUpgrade(sqld, fromVersion, toVersion);
        }
    }

    public void dropAll() {
        Log.i((String)TAG, (String)"DatabaseHelper.dropAll()");
        for (TypeDaoImpl<? extends Object, Long> dao : this.getDaos()) {
            dao.dropTable();
        }
    }
}

