/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.core.dao;

import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import net.sf.mardao.core.dao.TypeDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorIterable<T, ID extends Serializable>
extends SQLiteCursor
implements Iterable<T> {
    private boolean iterating = false;
    private boolean inIteration = false;
    private TypeDaoImpl<T, ID> dao;

    public CursorIterable(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        super(db, driver, editTable, query);
    }

    public CursorIterable(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query, TypeDaoImpl<T, ID> dao) {
        super(db, driver, editTable, query);
        this.dao = dao;
    }

    @Override
    public Iterator<T> iterator() {
        this.moveToFirst();
        this.iterating = true;
        return new CursorIterator();
    }

    public synchronized boolean onMove(int oldPosition, int newPosition) {
        if (this.inIteration) {
            if (!this.iterating) {
                throw new ConcurrentModificationException();
            }
        } else {
            this.iterating = false;
        }
        return super.onMove(oldPosition, newPosition);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorIterator
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return !CursorIterable.this.isAfterLast();
        }

        @Override
        public synchronized T next() {
            try {
                if (CursorIterable.this.isAfterLast()) {
                    return null;
                }
                Object domain = CursorIterable.this.dao.createDomain(CursorIterable.this);
                CursorIterable.this.inIteration = true;
                CursorIterable.this.moveToNext();
                CursorIterable.this.inIteration = false;
                return domain;
            }
            catch (InstantiationException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

