/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.test;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.mardao.core.dao.DUniqueDao;
import net.sf.mardao.core.domain.DUnique;
import net.sf.mardao.test.AbstractDatabaseInstrumentationTestCase;

public class TransactionTest
extends AbstractDatabaseInstrumentationTestCase {
    DUniqueDao dao;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dao = this.dbHelper.getDUniqueDao();
        this.dao.persist("first@mardao.sf.net", "Same");
        this.dao.persist("second@mardao.sf.net", "Same");
        this.dao.persist("third@mardao.sf.net", "Different");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreate50k() {
        ArrayList<DUnique> batch = new ArrayList<DUnique>();
        for (int i = 0; i < 50000; ++i) {
            DUnique d = new DUnique();
            d.setEmail(String.format("number%d@batch.com", i));
            d.setMessage("A common message");
            batch.add(d);
        }
        Collection<Long> actual = this.dbHelper.persistBatch(batch);
        TransactionTest.assertEquals((int)50000, (int)actual.size());
        for (Long id : actual) {
            TransactionTest.assertNotNull((Object)id);
        }
    }

    public static ArrayList asList(Iterable itrbl) {
        if (null == itrbl) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (Object o : itrbl) {
            list.add(o);
        }
        return list;
    }
}

