/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mardao.test;

import java.util.ArrayList;
import net.sf.mardao.core.dao.DUniqueDao;
import net.sf.mardao.core.domain.DUnique;
import net.sf.mardao.test.AbstractDatabaseInstrumentationTestCase;

public class QueryTest
extends AbstractDatabaseInstrumentationTestCase {
    DUniqueDao dao;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dao = this.dbHelper.getDUniqueDao();
        this.dao.persist("first@mardao.sf.net", "Same");
        this.dao.persist("second@mardao.sf.net", "Same");
        this.dao.persist("third@mardao.sf.net", "Different");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testQueryByBasic() {
        ArrayList actual = QueryTest.asList(this.dao.queryByMessage("Same"));
        QueryTest.assertNotNull((Object)actual);
        QueryTest.assertEquals((int)2, (int)actual.size());
        QueryTest.assertEquals((String)"Same", (String)((DUnique)((Object)actual.get(0))).getMessage());
        QueryTest.assertEquals((String)((DUnique)((Object)actual.get(0))).getMessage(), (String)((DUnique)((Object)actual.get(1))).getMessage());
        QueryTest.assertFalse((boolean)((DUnique)((Object)actual.get(0))).getEmail().equals(((DUnique)((Object)actual.get(1))).getEmail()));
    }

    public void testQueryUnique() {
        DUnique actual = this.dao.findByEmail("second@mardao.sf.net");
        QueryTest.assertNotNull((Object)((Object)actual));
        QueryTest.assertEquals((String)"second@mardao.sf.net", (String)actual.getEmail());
        actual = this.dao.findByEmail("fourth@example.com");
        QueryTest.assertNull((Object)((Object)actual));
    }

    public static ArrayList asList(Iterable itrbl) {
        if (null == itrbl) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (Object o : itrbl) {
            list.add(o);
        }
        return list;
    }
}

