/* Copyright (c) The m-m-m Team, Licensed under the Apache License, Version 2.0
 * http://www.apache.org/licenses/LICENSE-2.0 */
package net.sf.mmm.util.validation.base.text;

import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ObjectValidatorBuilder;

/**
 * The {@link ObjectValidatorBuilder builder} of {@link AbstractValidator} for {@link CharSequence} values.
 *
 * @param <PARENT> the generic type of the {@link #and() parent builder}.
 *
 * @author hohwille
 * @since 7.1.0
 */
public class ValidatorBuilderCharSequence<PARENT>
    extends CharSequenceValidatorBuilder<CharSequence, PARENT, ValidatorBuilderCharSequence<PARENT>> {

  /**
   * The constructor.
   *
   * @param parent the {@link #and() parent} builder.
   */
  public ValidatorBuilderCharSequence(PARENT parent) {
    super(parent);
  }

  @Override
  public ValidatorBuilderCharSequence<PARENT> range(String min, String max) {

    throw new UnsupportedOperationException();
  }

}
