/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.symmetric.key.spec;

import java.security.spec.KeySpec;
import javax.crypto.spec.PBEKeySpec;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeySpecFactory;

public class SymmetricKeySpecFactoryImplPbe
implements SymmetricKeySpecFactory {
    private byte[] salt;
    private int iterationCount;
    private int keyLength;

    public SymmetricKeySpecFactoryImplPbe() {
        this(null, 0, 0);
    }

    public SymmetricKeySpecFactoryImplPbe(byte[] salt) {
        this(salt, 0, 0);
    }

    public SymmetricKeySpecFactoryImplPbe(byte[] salt, int iterationCount) {
        this(salt, iterationCount, 0);
    }

    public SymmetricKeySpecFactoryImplPbe(byte[] salt, int iterationCount, int keyLength) {
        if (iterationCount < 0) {
            throw new IllegalArgumentException("iterationCount: " + iterationCount);
        }
        if (keyLength < 0) {
            throw new IllegalArgumentException("keyLength: " + keyLength);
        }
        if (salt == null) {
            if (iterationCount != 0 || keyLength != 0) {
                throw new IllegalArgumentException("No iterationCount or keyLength can be specified if salt is null!");
            }
            this.salt = null;
        } else {
            this.salt = (byte[])salt.clone();
        }
        this.keyLength = keyLength;
        this.iterationCount = iterationCount;
    }

    @Override
    public KeySpec createKeySpec(String password) {
        char[] pwd = password.toCharArray();
        if (this.salt == null) {
            assert (this.iterationCount == 0);
            assert (this.keyLength == 0);
            return new PBEKeySpec(pwd);
        }
        if (this.keyLength <= 0) {
            return new PBEKeySpec(pwd, this.salt, this.iterationCount);
        }
        return new PBEKeySpec(pwd, this.salt, this.iterationCount, this.keyLength);
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getKeyLength() {
        return this.keyLength;
    }
}

