/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.symmetric.key;

import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import net.sf.mmm.crypto.algorithm.AbstractCryptoAlgorithmWithProvider;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyConfig;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyCreator;

public class SymmetricKeyCreatorImpl<K extends SecretKey>
extends AbstractCryptoAlgorithmWithProvider
implements SymmetricKeyCreator<K> {
    private final SymmetricKeyConfig config;
    private SecretKeyFactory keyFactory;

    public SymmetricKeyCreatorImpl(SymmetricKeyConfig config) {
        super(config.getProvider());
        this.config = config;
    }

    @Override
    public String getAlgorithm() {
        return this.config.getAlgorithm();
    }

    @Override
    public int getKeyLength() {
        return this.config.getKeyLength();
    }

    @Override
    public int getKeyLength(K key) {
        return this.config.getKeyLength((SecretKey)key, this.getKeyFactory());
    }

    @Override
    public K createKey(String password) {
        try {
            KeySpec keySpec = this.config.getKeySpecFactory().createKeySpec(password);
            SecretKey secretKey = this.getKeyFactory().generateSecret(keySpec);
            return (K)secretKey;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create key pair for algorithm '" + this.getAlgorithm() + "'.", e);
        }
    }

    @Override
    public K createKey(byte[] key) {
        try {
            SecretKey secretKey = this.getKeyFactory().generateSecret(new SecretKeySpec(key, this.getAlgorithm()));
            return (K)secretKey;
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte[] asData(K key) {
        return key.getEncoded();
    }

    private SecretKeyFactory getKeyFactory() {
        if (this.keyFactory == null) {
            this.keyFactory = this.provider.createSecretKeyFactory(this.getAlgorithm());
        }
        return this.keyFactory;
    }
}

