/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.symmetric.key;

import javax.crypto.SecretKey;
import net.sf.mmm.binary.api.Binary;
import net.sf.mmm.crypto.CryptoBinary;
import net.sf.mmm.crypto.key.KeyCreator;

public interface SymmetricKeyCreator<K extends SecretKey>
extends KeyCreator {
    public K createKey(String var1);

    public K createKey(byte[] var1);

    public byte[] asData(K var1);

    default public Binary asBinary(K key) {
        return new CryptoBinary(this.asData(key));
    }

    default public void verifyKey(K key) {
        int givenKeyLength = this.getKeyLength(key);
        int expectedKeyLength = this.getKeyLength();
        if (givenKeyLength != 0 && givenKeyLength != expectedKeyLength) {
            throw new IllegalArgumentException("Secret key has a length of " + givenKeyLength + " bits but expected " + expectedKeyLength + " bits!");
        }
    }

    public int getKeyLength(K var1);
}

