/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.symmetric.crypt;

import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.sf.mmm.crypto.crypt.CryptorConfig;
import net.sf.mmm.crypto.crypt.CryptorFactoryImpl;
import net.sf.mmm.crypto.crypt.Decryptor;
import net.sf.mmm.crypto.crypt.Encryptor;
import net.sf.mmm.crypto.random.RandomFactory;
import net.sf.mmm.crypto.symmetric.crypt.SymmetricCryptorConfig;
import net.sf.mmm.crypto.symmetric.crypt.SymmetricCryptorFactory;

public class SymmetricCryptorFactoryImpl<K extends SecretKey>
extends CryptorFactoryImpl
implements SymmetricCryptorFactory<K> {
    private final SymmetricCryptorConfig config;

    public SymmetricCryptorFactoryImpl(SymmetricCryptorConfig config, RandomFactory randomFactory) {
        super(config.getProvider(), randomFactory);
        this.config = config;
    }

    @Override
    public Decryptor newDecryptorUnsafe(Key decryptionKey) {
        Key key = this.transformKey(decryptionKey);
        return super.newDecryptorUnsafe(key);
    }

    @Override
    public Encryptor newEncryptorUnsafe(Key encryptionKey) {
        Key key = this.transformKey(encryptionKey);
        return super.newEncryptorUnsafe(key);
    }

    @Override
    public SymmetricCryptorConfig getConfig() {
        return this.config;
    }

    private Key transformKey(Key encryptionKey) {
        Key key = encryptionKey;
        String algorithm = SymmetricCryptorFactoryImpl.getKeyAlgorithm(this.getConfig());
        if (!encryptionKey.getAlgorithm().equals(algorithm) && encryptionKey instanceof SecretKey) {
            key = new SecretKeySpec(encryptionKey.getEncoded(), algorithm);
        }
        return key;
    }

    private static String getKeyAlgorithm(CryptorConfig config) {
        String algorithm = config.getAlgorithm();
        int firstSlashIndex = algorithm.indexOf(47);
        if (firstSlashIndex > 0) {
            algorithm = algorithm.substring(0, firstSlashIndex);
        }
        return algorithm;
    }
}

