/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.symmetric.access;

import java.security.Key;
import java.util.Objects;
import javax.crypto.SecretKey;
import net.sf.mmm.crypto.CryptoAccess;
import net.sf.mmm.crypto.crypt.CryptorConfig;
import net.sf.mmm.crypto.crypt.Decryptor;
import net.sf.mmm.crypto.crypt.DecryptorImplCipher;
import net.sf.mmm.crypto.crypt.Encryptor;
import net.sf.mmm.crypto.crypt.EncryptorImplCiper;
import net.sf.mmm.crypto.key.AbstractGetKeyLength;
import net.sf.mmm.crypto.random.RandomFactory;
import net.sf.mmm.crypto.symmetric.crypt.SymmetricCryptorFactory;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyConfig;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyCreator;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyCreatorFactory;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyCreatorImpl;

public abstract class SymmetricAccess<K extends SecretKey>
extends CryptoAccess
implements SymmetricKeyCreatorFactory<SymmetricKeyCreator<K>>,
SymmetricCryptorFactory<K>,
AbstractGetKeyLength {
    private final SymmetricKeyConfig keyConfig;
    private final CryptorConfig cryptorConfig;
    private RandomFactory randomFactory;
    private SymmetricKeyCreator<K> keyCreator;

    public SymmetricAccess(SymmetricKeyConfig keyConfig, CryptorConfig cryptorConfig) {
        Objects.requireNonNull(keyConfig, "keyConfig");
        this.keyConfig = keyConfig;
        Objects.requireNonNull(cryptorConfig, "cryptorConfig");
        this.cryptorConfig = cryptorConfig;
    }

    @Override
    public SymmetricKeyCreator<K> newKeyCreator() {
        return new SymmetricKeyCreatorImpl(this.keyConfig);
    }

    private SymmetricKeyCreator<K> getKeyCreatorInternal() {
        if (this.keyCreator == null) {
            this.keyCreator = this.newKeyCreator();
        }
        return this.keyCreator;
    }

    public SymmetricKeyConfig getKeyConfig() {
        return this.keyConfig;
    }

    public CryptorConfig getCryptorConfig() {
        return this.cryptorConfig;
    }

    @Override
    public int getKeyLength() {
        return this.keyConfig.getKeyLength();
    }

    @Override
    public Decryptor newDecryptor(K decryptionKey) {
        this.getKeyCreatorInternal().verifyKey(decryptionKey);
        return this.newDecryptorUnsafe((Key)decryptionKey);
    }

    @Override
    public Encryptor newEncryptor(K encryptionKey) {
        this.getKeyCreatorInternal().verifyKey(encryptionKey);
        return this.newEncryptorUnsafe((Key)encryptionKey);
    }

    @Override
    public Encryptor newEncryptorUnsafe(Key encryptionKey) {
        return new EncryptorImplCiper(this.randomFactory, this.cryptorConfig, encryptionKey);
    }

    @Override
    public Decryptor newDecryptorUnsafe(Key decryptionKey) {
        return new DecryptorImplCipher(this.randomFactory, this.cryptorConfig, decryptionKey);
    }
}

