/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.random;

import java.security.Provider;
import java.security.SecureRandom;
import net.sf.mmm.crypto.algorithm.AbstractCryptoAlgorithmWithProvider;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomConfig;
import net.sf.mmm.crypto.random.RandomCreator;
import net.sf.mmm.crypto.random.RandomCreatorImpl;
import net.sf.mmm.crypto.random.RandomFactory;

public class RandomFactoryImpl
extends AbstractCryptoAlgorithmWithProvider
implements RandomFactory {
    private static RandomFactoryImpl STRONG_INSTANCE;
    private final RandomConfig config;

    public RandomFactoryImpl(RandomConfig config) {
        super(config.getProvider());
        this.config = config;
    }

    @Override
    public String getAlgorithm() {
        return this.config.getAlgorithm();
    }

    @Override
    public RandomCreator newRandomCreator() {
        return new RandomCreatorImpl(this.newSecureRandom(), this.config.getReseedCount());
    }

    @Override
    public SecureRandom newSecureRandom() {
        return this.provider.createSecureRandom(this.getAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RandomFactoryImpl ofStrong() {
        if (STRONG_INSTANCE != null) return STRONG_INSTANCE;
        Class<RandomFactoryImpl> clazz = RandomFactoryImpl.class;
        synchronized (RandomFactoryImpl.class) {
            if (STRONG_INSTANCE != null) return STRONG_INSTANCE;
            try {
                SecureRandom sample = SecureRandom.getInstanceStrong();
                Provider provider = sample.getProvider();
                RandomConfig configuration = new RandomConfig(sample.getAlgorithm(), SecurityProvider.of(provider));
                STRONG_INSTANCE = new RandomFactoryImpl(configuration);
            }
            catch (Exception e) {
                throw new IllegalStateException("No implementation of strong SecureRandom available!", e);
            }
            return STRONG_INSTANCE;
        }
    }
}

