/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.random;

import java.security.SecureRandom;
import net.sf.mmm.crypto.random.RandomCreator;

public class RandomCreatorImpl
implements RandomCreator {
    private final SecureRandom secureRandom;
    private final int reseedCount;
    private int count;

    public RandomCreatorImpl(SecureRandom secureRandom, int reseedCount) {
        this.secureRandom = secureRandom;
        this.reseedCount = reseedCount;
    }

    @Override
    public String getAlgorithm() {
        return this.secureRandom.getAlgorithm();
    }

    @Override
    public byte[] nextRandom(int bytes) {
        if (this.count >= this.reseedCount) {
            this.secureRandom.setSeed(this.secureRandom.generateSeed(64 + (this.secureRandom.nextInt() & 0xFF)));
            this.count = 0;
        }
        byte[] data = new byte[bytes];
        this.secureRandom.nextBytes(data);
        ++this.count;
        return data;
    }
}

