/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.random;

import net.sf.mmm.crypto.algorithm.CryptoAlgorithmConfig;
import net.sf.mmm.crypto.provider.SecurityProvider;

public class RandomConfig
extends CryptoAlgorithmConfig {
    private final int reseedCount;

    public RandomConfig(String algorithm) {
        this(algorithm, Integer.MAX_VALUE);
    }

    public RandomConfig(String algorithm, int reseedCount) {
        this(algorithm, reseedCount, null);
    }

    public RandomConfig(String algorithm, SecurityProvider provider) {
        this(algorithm, Integer.MAX_VALUE, provider);
    }

    public RandomConfig(String algorithm, int reseedCount, SecurityProvider provider) {
        super(algorithm, provider);
        if (reseedCount <= 0) {
            throw new IllegalArgumentException("reseedCount:" + reseedCount);
        }
        this.reseedCount = reseedCount;
    }

    public int getReseedCount() {
        return this.reseedCount;
    }
}

