/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.provider;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;

public final class SecurityProvider {
    public static final SecurityProvider DEFAULT = new SecurityProvider();
    public static final SecurityProvider BC = new SecurityProvider("BC");
    private final Provider provider;
    private final String providerName;

    private SecurityProvider() {
        this.provider = null;
        this.providerName = null;
    }

    private SecurityProvider(String providerName) {
        this(null, providerName);
    }

    private SecurityProvider(Provider provider) {
        this(provider, provider.getName());
    }

    private SecurityProvider(Provider provider, String providerName) {
        Objects.requireNonNull(providerName, "providerName");
        this.provider = provider;
        this.providerName = providerName;
    }

    public KeyPairGenerator createKeyPairGenerator(String algorithm) {
        try {
            Objects.requireNonNull(algorithm, "algorithm");
            if (this.provider != null) {
                return KeyPairGenerator.getInstance(algorithm, this.provider);
            }
            if (this.providerName != null) {
                return KeyPairGenerator.getInstance(algorithm, this.providerName);
            }
            return KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported key-pair-generator algorithm '" + algorithm + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public SecretKeyFactory createSecretKeyFactory(String algorithm) {
        try {
            Objects.requireNonNull(algorithm, "algorithm");
            if (this.provider != null) {
                return SecretKeyFactory.getInstance(algorithm, this.provider);
            }
            if (this.providerName != null) {
                return SecretKeyFactory.getInstance(algorithm, this.providerName);
            }
            return SecretKeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported secret-key-factory algorithm '" + algorithm + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public Signature createSignature(String algorithm) {
        Objects.requireNonNull(algorithm, "algorithm");
        try {
            if (this.provider != null) {
                return Signature.getInstance(algorithm, this.provider);
            }
            if (this.providerName != null) {
                return Signature.getInstance(algorithm, this.providerName);
            }
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported signature algorithm '" + algorithm + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public Cipher createCipher(String transformation) {
        Objects.requireNonNull(transformation, "transformation");
        try {
            if (this.provider != null) {
                return Cipher.getInstance(transformation, this.provider);
            }
            if (this.providerName != null) {
                return Cipher.getInstance(transformation, this.providerName);
            }
            return Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Unsupported encryption algorithm (cipher transformation) '" + transformation + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public MessageDigest createDigest(String algorithm) {
        Objects.requireNonNull(algorithm, "algorithm");
        try {
            if (this.provider != null) {
                return MessageDigest.getInstance(algorithm, this.provider);
            }
            if (this.providerName != null) {
                return MessageDigest.getInstance(algorithm, this.providerName);
            }
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported hash algorithm '" + algorithm + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public SecureRandom createSecureRandom(String algorithm) {
        try {
            Objects.requireNonNull(algorithm, "algorithm");
            if (this.provider != null) {
                return SecureRandom.getInstance(algorithm, this.provider);
            }
            if (this.providerName != null) {
                return SecureRandom.getInstance(algorithm, this.providerName);
            }
            return SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported secure-random-factory algorithm '" + algorithm + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public CertificateFactory createCertificateFactory(String type) {
        try {
            Objects.requireNonNull(type, "type");
            if (this.provider != null) {
                return CertificateFactory.getInstance(type, this.provider);
            }
            if (this.providerName != null) {
                return CertificateFactory.getInstance(type, this.providerName);
            }
            return CertificateFactory.getInstance(type);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Unsupported certificate-factory type '" + type + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public KeyFactory createKeyFactory(String algorithm) {
        try {
            Objects.requireNonNull(algorithm, "algorithm");
            if (this.provider != null) {
                return KeyFactory.getInstance(algorithm, this.provider);
            }
            if (this.providerName != null) {
                return KeyFactory.getInstance(algorithm, this.providerName);
            }
            return KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported key-factory algorithm '" + algorithm + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public KeyStore createKeyStore(String type) {
        try {
            Objects.requireNonNull(type, "type");
            if (this.provider != null) {
                return KeyStore.getInstance(type, this.provider);
            }
            if (this.providerName != null) {
                return KeyStore.getInstance(type, this.providerName);
            }
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Unsupported key-store type '" + type + "' for " + this.toString(), e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Unsupported security provider '" + this.providerName + "'.", e);
        }
    }

    public String toString() {
        if (this.providerName == null) {
            return "SecurityProvider: default";
        }
        return "SecurityProdivder: " + this.providerName;
    }

    public static SecurityProvider of(String name) {
        if (SecurityProvider.BC.providerName.equals(name)) {
            return BC;
        }
        return new SecurityProvider(name);
    }

    public static SecurityProvider of(Provider provider) {
        Objects.requireNonNull(provider, "provider");
        return new SecurityProvider(provider);
    }
}

