/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.key.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import net.sf.mmm.crypto.asymmetric.cert.CertificatePath;
import net.sf.mmm.crypto.asymmetric.key.AsymmetricKeyPair;
import net.sf.mmm.crypto.asymmetric.key.generic.AsymmetricKeyPairGeneric;
import net.sf.mmm.crypto.asymmetric.key.rsa.AsymmetricKeyPairRsa;
import net.sf.mmm.crypto.io.CryptoResource;
import net.sf.mmm.crypto.key.KeySet;
import net.sf.mmm.crypto.key.store.KeyStoreConfig;
import net.sf.mmm.crypto.key.store.KeyStoreFacade;
import net.sf.mmm.crypto.symmetric.key.SymmetricKeyGeneric;

public class KeyStoreFacadeImpl
implements KeyStoreFacade {
    private static final Certificate[] NO_CHAIN = null;
    private final KeyStoreConfig config;
    private final char[] password;
    private KeyStore keyStore;

    public KeyStoreFacadeImpl(KeyStoreConfig config) {
        this.config = config;
        this.password = KeyStoreFacadeImpl.getChars(config.getPassword());
    }

    private static char[] getChars(String password) {
        if (password == null) {
            return null;
        }
        return password.toCharArray();
    }

    @Override
    public KeyStore getKeyStore() {
        if (this.keyStore == null) {
            KeyStore ks;
            block18: {
                String type = this.config.getType();
                ks = this.config.getProvider().createKeyStore(this.config.getType());
                CryptoResource resource = this.config.getResource();
                if (resource.exists()) {
                    try (InputStream in = resource.openInputStream();){
                        ks.load(in, this.password);
                        break block18;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to load KeyStore of type " + type + " from " + resource.getUri() + "!", e);
                    }
                }
                try {
                    ks.load(null, null);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to initialize KeyStore of type " + type + "!", e);
                }
            }
            this.keyStore = ks;
        }
        return this.keyStore;
    }

    @Override
    public KeySet getKey(String alias, String keyPassword) {
        try {
            char[] pwd = keyPassword.toCharArray();
            KeyStore ks = this.getKeyStore();
            Key key = ks.getKey(alias, pwd);
            if (key instanceof PrivateKey) {
                PrivateKey privateKey = (PrivateKey)key;
                Certificate certificate = ks.getCertificate(alias);
                PublicKey publicKey = certificate.getPublicKey();
                if (privateKey instanceof RSAPrivateKey) {
                    return new AsymmetricKeyPairRsa((RSAPrivateKey)privateKey, (RSAPublicKey)publicKey);
                }
                return new AsymmetricKeyPairGeneric(privateKey, publicKey);
            }
            if (key instanceof SecretKey) {
                return new SymmetricKeyGeneric<SecretKey>((SecretKey)key);
            }
            throw new IllegalStateException("Unsupported key (class: " + key.getClass().getSimpleName() + ", format: " + key.getFormat() + "algorithm: " + key.getAlgorithm() + ")");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get Key with alias " + alias + " from KeyStore of type " + this.config.getType() + " at " + this.config.getResource().getUri() + "!", e);
        }
    }

    @Override
    public void setKey(String alias, AsymmetricKeyPair<?, ?> keyPair, String password, CertificatePath certificatePath) {
        this.setKeyPairInternal(alias, (Key)keyPair.getPrivateKey(), password, certificatePath);
    }

    @Override
    public void setKey(String alias, SecretKey key, String password) {
        this.setKeyPairInternal(alias, key, password, null);
    }

    private void setKeyPairInternal(String alias, Key secureKey, String password, CertificatePath certificatePath) {
        Certificate[] chain;
        Objects.requireNonNull(secureKey, "secureKey");
        if (certificatePath == null) {
            chain = NO_CHAIN;
        } else {
            List<Certificate> certificates = certificatePath.getCertificates();
            chain = new Certificate[certificates.size()];
            for (int i = 0; i < chain.length; ++i) {
                chain[i] = certificates.get(i);
            }
        }
        try {
            this.getKeyStore().setKeyEntry(alias, secureKey, KeyStoreFacadeImpl.getChars(password), chain);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set Key with alias " + alias + " to KeyStore of type " + this.config.getType() + " at " + this.config.getResource().getUri() + "!", e);
        }
    }

    @Override
    public void save() {
        block16: {
            if (this.keyStore == null) {
                return;
            }
            CryptoResource resource = this.config.getResource();
            String type = this.config.getType();
            OutputStream outputStream = resource.openOutputStream();
            try {
                if (outputStream == null) {
                    this.keyStore.store(null, this.password);
                    break block16;
                }
                try (OutputStream out = outputStream;){
                    this.keyStore.store(out, this.password);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to save KeyStore of type " + type + " to " + resource.getUri() + "!", e);
            }
        }
    }

    public String toString() {
        return this.config.getType() + "-KeyStore@" + this.config.getResource().getUri();
    }
}

