/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.key.store;

import java.util.Locale;
import java.util.Objects;
import net.sf.mmm.crypto.io.CryptoResource;
import net.sf.mmm.crypto.provider.SecurityProvider;

public class KeyStoreConfig {
    private final String type;
    private final SecurityProvider provider;
    private final CryptoResource resource;
    private final String password;

    public KeyStoreConfig(String type, CryptoResource resource, String password) {
        this(type, null, resource, password);
    }

    public KeyStoreConfig(String type, SecurityProvider provider, CryptoResource resource, String password) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(password, "password");
        this.type = type;
        this.provider = provider == null ? SecurityProvider.DEFAULT : provider;
        this.resource = resource;
        this.password = password;
    }

    public String getExtension() {
        return "." + this.type.toLowerCase(Locale.US);
    }

    public String getType() {
        return this.type;
    }

    public SecurityProvider getProvider() {
        return this.provider;
    }

    public CryptoResource getResource() {
        return this.resource;
    }

    public String getPassword() {
        return this.password;
    }
}

