/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.io;

import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamWrapper
extends OutputStream {
    private final OutputStream delegate;
    private boolean closed;

    public OutputStreamWrapper() {
        this(null);
    }

    public OutputStreamWrapper(OutputStream delegate) {
        this.delegate = delegate;
        this.closed = false;
    }

    protected OutputStream getDelegate() {
        return this.delegate;
    }

    protected void requireNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed.");
        }
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.requireNotClosed();
        if (this.delegate != null) {
            this.delegate.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.requireNotClosed();
        if (this.delegate != null) {
            this.delegate.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = false;
    }

    protected boolean isClosed() {
        return this.closed;
    }
}

