/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class InputStreamWrapper
extends InputStream {
    private final InputStream delegate;
    private boolean closed;

    public InputStreamWrapper(InputStream delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.closed = false;
    }

    protected InputStream getDelegate() {
        return this.delegate;
    }

    protected void requireNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed.");
        }
    }

    @Override
    public int read() throws IOException {
        this.requireNotClosed();
        return this.delegate.read();
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.requireNotClosed();
        return this.delegate.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.closed = false;
    }
}

