/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.sf.mmm.crypto.io.CryptoResource;

public class CryptoFileResource
implements CryptoResource {
    private final File file;

    public CryptoFileResource(File file) {
        this.file = file;
        this.verifyNotDirectory();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean exists() {
        return this.file.exists() && !this.file.isDirectory();
    }

    private void ensureExists() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                Files.createFile(this.file.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("File " + this.file.getPath() + " could not be created!", e);
            }
        }
        this.verifyNotDirectory();
    }

    private void verifyNotDirectory() {
        if (this.file.isDirectory()) {
            throw new IllegalStateException("Resource is a directory: " + this.file.getPath());
        }
    }

    @Override
    public String getUri() {
        return this.file.toString();
    }

    @Override
    public InputStream openInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File " + this.file.getPath() + " does not exist!", e);
        }
    }

    @Override
    public OutputStream openOutputStream() {
        this.ensureExists();
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File " + this.file.getPath() + " does not exist!", e);
        }
    }
}

