/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash.access;

import net.sf.mmm.crypto.CryptoAccess;
import net.sf.mmm.crypto.hash.HashConfig;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashCreatorImplDigest;
import net.sf.mmm.crypto.hash.HashCreatorImplMultipleRounds;
import net.sf.mmm.crypto.hash.HashFactory;

public class HashAccess
extends CryptoAccess
implements HashFactory {
    private final HashConfig config;

    public HashAccess(HashConfig config) {
        if (config.getIterationCount() <= 0) {
            throw new IllegalArgumentException("config.iterationCount=" + config.getIterationCount());
        }
        this.config = config;
    }

    @Override
    public HashCreator newHashCreator() {
        int iterationCount = this.config.getIterationCount();
        if (iterationCount <= 1) {
            return new HashCreatorImplDigest(this.config.getAlgorithm(), this.config.getProvider());
        }
        return new HashCreatorImplMultipleRounds(this.config.getAlgorithm(), this.config.getProvider(), iterationCount);
    }

    public String toString() {
        return this.config.getAlgorithm();
    }

    public static HashAccess of(HashConfig config) {
        return new HashAccess(config);
    }
}

