/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.io.OutputStreamWrapper;

public class HashOutputStream
extends OutputStreamWrapper {
    private final HashCreator hashGenerator;

    public HashOutputStream(HashCreator hashGenerator) {
        this(hashGenerator, null);
    }

    public HashOutputStream(HashCreator hashGenerator, OutputStream delegate) {
        super(delegate);
        this.hashGenerator = hashGenerator;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.hashGenerator.update(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.hashGenerator.update(new byte[]{(byte)b});
    }
}

