/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash;

import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashCreatorImplCombined;
import net.sf.mmm.crypto.hash.HashFactory;

public class HashFactoryCombined
implements HashFactory {
    private final HashFactory[] factories;

    public HashFactoryCombined(HashFactory[] factories) {
        this.factories = factories;
    }

    @Override
    public HashCreator newHashCreator() {
        HashCreator[] generators = new HashCreator[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            generators[i] = this.factories[i].newHashCreator();
        }
        return new HashCreatorImplCombined(generators);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (HashFactory factory : this.factories) {
            if (buffer.length() > 0) {
                buffer.append('+');
            }
            buffer.append(factory);
        }
        return buffer.toString();
    }
}

