/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash;

import java.security.MessageDigest;
import net.sf.mmm.crypto.hash.HashCreatorImplDigest;
import net.sf.mmm.crypto.provider.SecurityProvider;

public class HashCreatorImplMultipleRounds
extends HashCreatorImplDigest {
    private final MessageDigest roundDigest;
    private final int iterationCount;

    public HashCreatorImplMultipleRounds(String hashAlgorithm, SecurityProvider provider, int iterationCount) {
        super(hashAlgorithm, provider);
        if (iterationCount <= 1) {
            throw new IllegalArgumentException("Iteration count (" + iterationCount + ") has to be greater than 1!");
        }
        this.roundDigest = this.getProvider().createDigest(hashAlgorithm);
        this.iterationCount = iterationCount;
    }

    @Override
    public byte[] hash(boolean reset) {
        byte[] hash = super.hash(reset);
        for (int i = 1; i < this.iterationCount; ++i) {
            hash = this.roundDigest.digest(hash);
        }
        return hash;
    }
}

