/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash;

import java.io.OutputStream;
import java.security.MessageDigest;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithmImpl;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashOutputStream;
import net.sf.mmm.crypto.provider.SecurityProvider;

public class HashCreatorImplDigest
extends CryptoAlgorithmImpl
implements HashCreator {
    private final MessageDigest digest;

    public HashCreatorImplDigest(String hashAlgorithm, SecurityProvider provider) {
        super(hashAlgorithm, provider);
        this.digest = this.getProvider().createDigest(hashAlgorithm);
    }

    @Override
    public OutputStream wrapStream(OutputStream out) {
        return new HashOutputStream(this, out);
    }

    @Override
    public void update(byte[] input, int offset, int length) {
        this.digest.update(input, offset, length);
    }

    @Override
    public byte[] hash(boolean reset) {
        MessageDigest messageDigest = HashCreatorImplDigest.getOrCloneMessageDigest(this.digest, !reset);
        return messageDigest.digest();
    }

    protected static MessageDigest getOrCloneMessageDigest(MessageDigest messageDigest, boolean clone) {
        if (!clone) {
            return messageDigest;
        }
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

