/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash;

import java.io.OutputStream;
import net.sf.mmm.crypto.algorithm.AbstractSecurityAlgorithm;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashOutputStream;

public class HashCreatorImplCombined
extends AbstractSecurityAlgorithm
implements HashCreator {
    private final HashCreator[] generators;

    public HashCreatorImplCombined(HashCreator[] generators) {
        this.generators = generators;
    }

    @Override
    public String getAlgorithm() {
        return HashCreatorImplCombined.getAlgorithm(this.generators);
    }

    @Override
    public OutputStream wrapStream(OutputStream out) {
        return new HashOutputStream(this, out);
    }

    @Override
    public void update(byte[] input, int offset, int length) {
        this.generators[0].update(input, offset, length);
    }

    @Override
    public byte[] hash(boolean reset) {
        byte[] hash = null;
        for (HashCreator generator : this.generators) {
            if (hash != null) {
                generator.update(hash);
            }
            hash = generator.hash(reset);
        }
        return hash;
    }

    @Override
    public void reset() {
        for (HashCreator generator : this.generators) {
            generator.reset();
        }
    }
}

