/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.hash;

import net.sf.mmm.crypto.AbstractGetIterationCount;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithmConfig;
import net.sf.mmm.crypto.hash.HashCreator;
import net.sf.mmm.crypto.hash.HashFactory;
import net.sf.mmm.crypto.hash.access.HashAccess;
import net.sf.mmm.crypto.provider.SecurityProvider;

public class HashConfig
extends CryptoAlgorithmConfig
implements AbstractGetIterationCount,
HashFactory {
    public static final String ALGORITHM_NONE = "NONE";
    private final int iterationCount;

    public HashConfig(String algorithm) {
        this(algorithm, null, 1);
    }

    public HashConfig(String algorithm, int iterationCount) {
        this(algorithm, null, iterationCount);
    }

    public HashConfig(String algorithm, SecurityProvider provider) {
        this(algorithm, provider, 1);
    }

    public HashConfig(String algorithm, SecurityProvider provider, int iterationCount) {
        super(algorithm, provider);
        if (iterationCount < 0) {
            throw new IllegalArgumentException("iterationCount:" + iterationCount);
        }
        this.iterationCount = iterationCount;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    public HashConfig decrementIterationCount() {
        if (this.iterationCount <= 0) {
            return null;
        }
        return new HashConfig(this.getAlgorithm(), this.provider, this.iterationCount - 1);
    }

    public HashAccess newAccess() {
        return new HashAccess(this);
    }

    @Override
    public HashCreator newHashCreator() {
        return this.newAccess().newHashCreator();
    }
}

