/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.crypt;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.mmm.crypto.crypt.Cryptor;
import net.sf.mmm.crypto.io.OutputStreamWrapper;

public class CryptorOutputStream
extends OutputStreamWrapper {
    private Cryptor cryptor;

    public CryptorOutputStream(Cryptor cryptor, OutputStream delegate) {
        super(delegate);
        this.cryptor = cryptor;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.requireNotClosed();
        byte[] data = this.cryptor.crypt(b, off, len, false);
        super.write(data);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] data = this.cryptor.crypt(new byte[]{(byte)b}, false);
        super.write(data);
    }

    @Override
    public void close() throws IOException {
        byte[] data;
        if (!this.isClosed() && (data = this.cryptor.doFinal()) != null && data.length > 0) {
            super.write(data);
        }
        super.close();
        this.cryptor = null;
    }
}

