/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.crypt;

import net.sf.mmm.crypto.algorithm.AbstractSecurityAlgorithm;
import net.sf.mmm.crypto.crypt.Cryptor;

public abstract class CryptorImplCombined
extends AbstractSecurityAlgorithm
implements Cryptor {
    private Cryptor[] cryptors;

    public CryptorImplCombined(Cryptor[] cryptors) {
        this.cryptors = cryptors;
    }

    @Override
    public String getAlgorithm() {
        return CryptorImplCombined.getAlgorithm(this.cryptors);
    }

    @Override
    public int getNonceSize() {
        return this.getLastCryptor().getNonceSize();
    }

    protected Cryptor getLastCryptor() {
        return this.cryptors[this.cryptors.length - 1];
    }

    @Override
    public byte[] crypt(byte[] input, int offset, int length, boolean complete) {
        byte[] result = null;
        for (Cryptor cryptor : this.cryptors) {
            result = result == null ? cryptor.crypt(input, offset, length, complete) : cryptor.crypt(result, complete);
        }
        return result;
    }

    @Override
    public void reset() {
        for (Cryptor cryptor : this.cryptors) {
            cryptor.reset();
        }
    }
}

