/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.crypt;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import net.sf.mmm.binary.api.Binary;
import net.sf.mmm.crypto.algorithm.AbstractCryptoAlgorithmWithRandom;
import net.sf.mmm.crypto.crypt.Cryptor;
import net.sf.mmm.crypto.crypt.CryptorConfig;
import net.sf.mmm.crypto.random.RandomFactory;

public abstract class CryptorImplCipher
extends AbstractCryptoAlgorithmWithRandom
implements Cryptor {
    private final CryptorConfig config;
    private final Key key;
    private final int nonceSize;
    private Cipher cipher;
    private byte[] nonce;
    private int nonceIndex;

    public CryptorImplCipher(RandomFactory randomFactory, CryptorConfig config, Key key) {
        super(config.getProvider(), randomFactory);
        this.key = key;
        this.config = config;
        this.nonceSize = config.getNonceSize();
    }

    @Override
    public String getAlgorithm() {
        return this.config.getAlgorithm();
    }

    @Override
    public int getNonceSize() {
        return this.nonceSize;
    }

    protected Cipher getCipher() {
        if (this.cipher == null) {
            try {
                int opmode;
                this.cipher = this.getProvider().createCipher(this.getAlgorithm());
                IvParameterSpec parameters = null;
                SecureRandom secureRandom = this.getRandomFactory().newSecureRandom();
                boolean encryptor = this.isEncryptor();
                if (encryptor) {
                    opmode = 1;
                    if (this.nonceSize > 0 && this.config.isCreateRandomNonce()) {
                        this.nonce = new byte[this.nonceSize];
                        secureRandom.nextBytes(this.nonce);
                        parameters = new IvParameterSpec(this.nonce);
                    }
                } else {
                    opmode = 2;
                    if (this.nonceSize > 0) {
                        Objects.requireNonNull(this.nonce, "nonce");
                        if (this.nonce.length != this.nonceSize) {
                            throw new IllegalStateException("Required nonce size is " + this.nonceSize + " but " + this.nonce.length + " was found!");
                        }
                        parameters = new IvParameterSpec(this.nonce);
                        this.nonce = null;
                    }
                    this.nonceIndex = -1;
                }
                if (parameters == null) {
                    this.cipher.init(opmode, this.key, secureRandom);
                } else {
                    this.cipher.init(opmode, this.key, parameters, secureRandom);
                }
                if (encryptor && this.nonceSize > 0 && !this.config.isCreateRandomNonce()) {
                    this.nonce = this.cipher.getIV();
                    assert (this.nonceSize == this.nonce.length);
                }
            }
            catch (Exception e) {
                throw this.creationFailedException(e, Cipher.class);
            }
        }
        return this.cipher;
    }

    protected abstract boolean isEncryptor();

    public final CryptorConfig getConfig() {
        return this.config;
    }

    protected String getMode() {
        if (this.isEncryptor()) {
            return "encryption";
        }
        return "decryption";
    }

    private int readNonce(byte[] input, int off, int len) {
        int nonceBytes;
        assert (this.nonceIndex >= 0);
        if (this.nonce == null) {
            this.nonce = new byte[this.nonceSize];
            this.nonceIndex = 0;
        }
        if ((nonceBytes = this.nonce.length - this.nonceIndex) > 0) {
            if (nonceBytes > len) {
                nonceBytes = len;
            }
            System.arraycopy(input, off, this.nonce, this.nonceIndex, nonceBytes);
            this.nonceIndex += nonceBytes;
            return nonceBytes;
        }
        return 0;
    }

    @Override
    public byte[] crypt(byte[] input, int offset, int length, boolean complete) {
        try {
            int off = offset;
            int len = length;
            if (this.nonceSize > 0 && this.nonceIndex >= 0 && !this.isEncryptor()) {
                int nonceBytes = this.readNonce(input, off, len);
                off += nonceBytes;
                if ((len -= nonceBytes) <= 0) {
                    return Binary.EMPTY_BYTE_ARRAY;
                }
            }
            byte[] result = complete ? this.getCipher().doFinal(input, off, len) : this.getCipher().update(input, off, len);
            if (this.nonceSize > 0 && this.nonceIndex == 0 && this.isEncryptor()) {
                byte[] data = new byte[result.length + this.nonceSize];
                System.arraycopy(this.nonce, 0, data, 0, this.nonceSize);
                this.nonceIndex = -1;
                System.arraycopy(result, 0, data, this.nonceSize, result.length);
                result = data;
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw this.wrapSecurityException(e);
        }
    }

    protected RuntimeException wrapSecurityException(Exception e) {
        return new IllegalStateException("The " + this.getMode() + " failed: " + e.getMessage(), e);
    }

    @Override
    public void reset() {
        if (this.cipher != null) {
            try {
                this.cipher.doFinal();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cipher = null;
        }
        this.nonce = null;
        this.nonceIndex = 0;
    }
}

