/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.crypt;

import java.security.Key;
import net.sf.mmm.crypto.algorithm.AbstractCryptoAlgorithmWithRandom;
import net.sf.mmm.crypto.crypt.CryptorConfig;
import net.sf.mmm.crypto.crypt.CryptorFactory;
import net.sf.mmm.crypto.crypt.Decryptor;
import net.sf.mmm.crypto.crypt.DecryptorImplCipher;
import net.sf.mmm.crypto.crypt.Encryptor;
import net.sf.mmm.crypto.crypt.EncryptorImplCiper;
import net.sf.mmm.crypto.provider.SecurityProvider;
import net.sf.mmm.crypto.random.RandomFactory;

public abstract class CryptorFactoryImpl
extends AbstractCryptoAlgorithmWithRandom
implements CryptorFactory {
    public CryptorFactoryImpl(SecurityProvider provider, RandomFactory randomFactory) {
        super(provider, randomFactory);
    }

    public abstract CryptorConfig getConfig();

    @Override
    public String getAlgorithm() {
        return this.getConfig().getAlgorithm();
    }

    @Override
    public Encryptor newEncryptorUnsafe(Key encryptionKey) {
        return new EncryptorImplCiper(this.getRandomFactory(), this.getConfig(), encryptionKey);
    }

    @Override
    public Decryptor newDecryptorUnsafe(Key decryptionKey) {
        return new DecryptorImplCipher(this.getRandomFactory(), this.getConfig(), decryptionKey);
    }
}

