/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.crypt;

import java.util.Objects;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;

public class CipherTransformation
implements CryptoAlgorithm {
    public static final String PADDING_NONE = "NoPadding";
    public static final String MODE_GCM = "GCM";
    private static final String SEPARATOR = "/";
    private final String algorithm;
    private final String mode;
    private final String padding;
    private final String transformation;

    public CipherTransformation(String algorithm) {
        this(algorithm, null, null);
    }

    public CipherTransformation(String algorithm, String mode, String padding) {
        Objects.requireNonNull(algorithm, "algorithm");
        this.algorithm = algorithm;
        this.mode = mode;
        this.padding = padding;
        this.transformation = padding == null ? (mode == null ? algorithm : algorithm + SEPARATOR + mode) : algorithm + SEPARATOR + mode + SEPARATOR + padding;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public int hashCode() {
        return this.transformation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof CipherTransformation)) {
            return false;
        }
        CipherTransformation other = (CipherTransformation)obj;
        return Objects.equals(this.transformation, other.transformation);
    }

    public String toString() {
        return this.transformation;
    }

    public static CipherTransformation of(String transformation) {
        if (transformation == null || transformation.isEmpty()) {
            return null;
        }
        String[] segments = transformation.split(SEPARATOR);
        if (segments.length == 1) {
            return new CipherTransformation(segments[0], null, null);
        }
        if (segments.length == 2) {
            return new CipherTransformation(segments[0], segments[1], null);
        }
        if (segments.length == 3) {
            return new CipherTransformation(segments[0], segments[1], segments[2]);
        }
        throw new IllegalArgumentException(transformation);
    }
}

