/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.hash.HashCreator;

public class SignatureVerifierImplWithHash<S extends SignatureBinary>
extends SignatureProcessorImplWithHash
implements SignatureVerifier<S> {
    private final SignatureVerifier<S> verifier;

    public SignatureVerifierImplWithHash(HashCreator hashGenerator, SignatureVerifier<S> verifier) {
        super(hashGenerator);
        this.verifier = verifier;
    }

    @Override
    protected SignatureVerifier<S> getSignatureAlgorithm() {
        return this.verifier;
    }

    @Override
    public boolean verifyAfterUpdate(byte[] signature, int offset, int length) {
        byte[] hash = this.getHashGenerator().hash(true);
        this.verifier.update(hash);
        return this.verifier.verifyAfterUpdate(signature);
    }

    @Override
    public boolean verifyAfterUpdate(S signature) {
        byte[] hash = this.getHashGenerator().hash(true);
        this.verifier.update(hash);
        return this.verifier.verifyAfterUpdate(signature);
    }

    @Override
    public void reset() {
        super.reset();
        this.verifier.reset();
    }
}

