/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.util.Arrays;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.crypt.Decryptor;
import net.sf.mmm.crypto.hash.HashCreator;

public class SignatureVerifierImplCryptorWithHash
extends SignatureProcessorImplWithHash
implements SignatureVerifier<SignatureBinary> {
    private final Decryptor decryptor;

    public SignatureVerifierImplCryptorWithHash(HashCreator hashGenerator, Decryptor decryptor) {
        super(hashGenerator);
        this.decryptor = decryptor;
    }

    @Override
    protected Decryptor getSignatureAlgorithm() {
        return this.decryptor;
    }

    @Override
    public boolean verifyAfterUpdate(byte[] signature, int offset, int length) {
        byte[] hash = this.getHashGenerator().hash(true);
        byte[] expectedHash = this.decryptor.crypt(signature, true);
        return Arrays.equals(hash, expectedHash);
    }

    @Override
    public void reset() {
        super.reset();
        this.decryptor.reset();
    }
}

