/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.security.Signature;
import java.security.SignatureException;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorImpl;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureVerifierImpl<S extends SignatureBinary>
extends SignatureProcessorImpl
implements SignatureVerifier<S> {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureVerifierImpl.class);

    public SignatureVerifierImpl(Signature signature) {
        super(signature);
    }

    @Override
    public boolean verifyAfterUpdate(byte[] signature, int offset, int length) {
        try {
            return this.getSignature().verify(signature, offset, length);
        }
        catch (SignatureException e) {
            LOG.warn("Error whilst verifying signature.", (Throwable)e);
            return false;
        }
    }
}

