/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import net.sf.mmm.crypto.CryptoBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifierSimple;

public interface SignatureVerifier<S extends SignatureBinary>
extends SignatureVerifierSimple {
    default public boolean verifyAfterUpdate(S signature) {
        return this.verifyAfterUpdate((S)signature.getData());
    }

    default public boolean verify(byte[] input, int offset, int length, S signature) {
        this.update(input, offset, length);
        return this.verifyAfterUpdate(signature);
    }

    default public boolean verify(byte[] input, S signature) {
        this.update(input);
        return this.verifyAfterUpdate(signature);
    }

    default public boolean verifyUnsafe(byte[] input, SignatureBinary signature) {
        return this.verify(input, signature);
    }

    default public boolean verify(CryptoBinary input, S signature) {
        this.update(input);
        return this.verifyAfterUpdate(signature);
    }
}

