/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.hash.HashCreator;

public class SignatureSignerImplWithHash<S extends SignatureBinary>
extends SignatureProcessorImplWithHash
implements SignatureSigner<S> {
    private final SignatureSigner<S> signer;

    public SignatureSignerImplWithHash(HashCreator hashGenerator, SignatureSigner<S> signer) {
        super(hashGenerator);
        this.signer = signer;
    }

    @Override
    protected CryptoAlgorithm getSignatureAlgorithm() {
        return this.signer;
    }

    @Override
    public S signAfterUpdate(boolean reset) {
        byte[] hash = this.getHashGenerator().hash(true);
        return this.signer.sign(hash, reset);
    }

    @Override
    public byte[] signAfterUpdateRaw(boolean reset) {
        byte[] hash = this.getHashGenerator().hash(true);
        this.signer.update(hash);
        byte[] signature = this.signer.signAfterUpdateRaw(reset);
        return signature;
    }

    @Override
    public void reset() {
        super.reset();
        this.signer.reset();
    }
}

