/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.asymmetric.sign.generic.SignatureGeneric;
import net.sf.mmm.crypto.crypt.Encryptor;
import net.sf.mmm.crypto.hash.HashCreator;

public class SignatureSignerImplCryptorWithHash
extends SignatureProcessorImplWithHash
implements SignatureSigner<SignatureBinary> {
    private final Encryptor encryptor;

    public SignatureSignerImplCryptorWithHash(HashCreator hashGenerator, Encryptor encryptor) {
        super(hashGenerator);
        this.encryptor = encryptor;
    }

    @Override
    protected CryptoAlgorithm getSignatureAlgorithm() {
        return this.encryptor;
    }

    @Override
    public SignatureGeneric signAfterUpdate(boolean reset) {
        return new SignatureGeneric(this.signAfterUpdateRaw(reset));
    }

    @Override
    public byte[] signAfterUpdateRaw(boolean reset) {
        byte[] hash = this.getHashGenerator().hash(true);
        byte[] signature = this.encryptor.process(hash);
        if (reset) {
            this.reset();
        }
        return signature;
    }

    @Override
    public void reset() {
        super.reset();
        this.encryptor.reset();
    }
}

