/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.security.Signature;
import java.security.SignatureException;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureFactory;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorImpl;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;

public class SignatureSignerImpl<S extends SignatureBinary>
extends SignatureProcessorImpl
implements SignatureSigner<S> {
    private SignatureFactory<S> factory;

    public SignatureSignerImpl(Signature signature, SignatureFactory<S> factory) {
        super(signature);
        this.factory = factory;
    }

    @Override
    public S signAfterUpdate(boolean reset) {
        return this.createSignature(this.signAfterUpdateRaw(reset));
    }

    protected S createSignature(byte[] signatureData) {
        return this.factory.createSignature(signatureData);
    }

    @Override
    public byte[] signAfterUpdateRaw(boolean reset) {
        try {
            byte[] signature = this.getSignature().sign();
            if (reset) {
                this.reset();
            }
            return signature;
        }
        catch (SignatureException e) {
            throw this.creationFailedException((Exception)e, Signature.class);
        }
    }
}

