/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import net.sf.mmm.crypto.algorithm.AbstractSecurityAlgorithm;
import net.sf.mmm.crypto.algorithm.CryptoAlgorithm;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessor;
import net.sf.mmm.crypto.hash.HashCreator;

public abstract class SignatureProcessorImplWithHash
extends AbstractSecurityAlgorithm
implements SignatureProcessor {
    private final HashCreator hashGenerator;

    public SignatureProcessorImplWithHash(HashCreator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    protected abstract CryptoAlgorithm getSignatureAlgorithm();

    protected HashCreator getHashGenerator() {
        return this.hashGenerator;
    }

    @Override
    public String getAlgorithm() {
        return this.hashGenerator.getAlgorithm() + "+" + this.getSignatureAlgorithm().getAlgorithm();
    }

    @Override
    public void update(byte[] input, int offset, int length) {
        this.hashGenerator.update(input, offset, length);
    }

    @Override
    public void reset() {
        this.hashGenerator.reset();
    }
}

