/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.security.PrivateKey;
import java.security.PublicKey;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorFactory;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSignerImplWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifierImplWithHash;
import net.sf.mmm.crypto.hash.HashFactory;

public class SignatureProcessorFactoryImplWithHash<S extends SignatureBinary, PR extends PrivateKey, PU extends PublicKey>
implements SignatureProcessorFactory<S, PR, PU> {
    private final SignatureProcessorFactory<S, PR, PU> signatureFactory;
    private final HashFactory hashFactory;

    public SignatureProcessorFactoryImplWithHash(SignatureProcessorFactory<S, PR, PU> signatureFactory, HashFactory hashFactory) {
        this.signatureFactory = signatureFactory;
        this.hashFactory = hashFactory;
    }

    @Override
    public SignatureSigner<S> newSigner(PR privateKey) {
        return new SignatureSignerImplWithHash<S>(this.hashFactory.newHashCreator(), this.signatureFactory.newSigner(privateKey));
    }

    @Override
    public SignatureVerifier<S> newVerifier(PU publicKey) {
        return new SignatureVerifierImplWithHash<S>(this.hashFactory.newHashCreator(), this.signatureFactory.newVerifier(publicKey));
    }

    @Override
    public S createSignature(byte[] data) {
        return this.signatureFactory.createSignature(data);
    }

    @Override
    public SignatureProcessorFactory<S, PR, PU> getSignatureFactoryWithoutHash() {
        return this.signatureFactory;
    }

    public String toString() {
        return this.hashFactory.toString() + "+" + this.signatureFactory.toString();
    }
}

