/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.crypto.asymmetric.sign;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.sf.mmm.crypto.asymmetric.crypt.AsymmetricCryptorConfig;
import net.sf.mmm.crypto.asymmetric.crypt.AsymmetricCryptorFactory;
import net.sf.mmm.crypto.asymmetric.crypt.AsymmetricCryptorFactoryImpl;
import net.sf.mmm.crypto.asymmetric.sign.SignatureBinary;
import net.sf.mmm.crypto.asymmetric.sign.SignatureProcessorFactory;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSigner;
import net.sf.mmm.crypto.asymmetric.sign.SignatureSignerImplCryptorWithHash;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifier;
import net.sf.mmm.crypto.asymmetric.sign.SignatureVerifierImplCryptorWithHash;
import net.sf.mmm.crypto.asymmetric.sign.generic.SignatureGeneric;
import net.sf.mmm.crypto.crypt.CryptorConfig;
import net.sf.mmm.crypto.hash.HashFactory;

public class SignatureProcessorFactoryImplCryptorWithHash<PR extends PrivateKey, PU extends PublicKey>
implements SignatureProcessorFactory<SignatureBinary, PR, PU> {
    private final HashFactory hashFactory;
    private final AsymmetricCryptorFactory<PR, PU> cryptorFactory;

    public SignatureProcessorFactoryImplCryptorWithHash(AsymmetricCryptorFactory<PR, PU> cryptorFactory, HashFactory hashFactory) {
        CryptorConfig config;
        if (cryptorFactory instanceof AsymmetricCryptorFactoryImpl && !((AsymmetricCryptorConfig)(config = ((AsymmetricCryptorFactoryImpl)cryptorFactory).getConfig())).isBidirectional()) {
            throw new IllegalStateException("Only bidirectional cryptor can be used for signature factory!");
        }
        this.hashFactory = hashFactory;
        this.cryptorFactory = cryptorFactory;
    }

    @Override
    public SignatureSigner<SignatureBinary> newSigner(PR privateKey) {
        return new SignatureSignerImplCryptorWithHash(this.hashFactory.newHashCreator(), this.cryptorFactory.newEncryptorUnsafe((Key)privateKey));
    }

    @Override
    public SignatureVerifier<SignatureBinary> newVerifier(PU publicKey) {
        return new SignatureVerifierImplCryptorWithHash(this.hashFactory.newHashCreator(), this.cryptorFactory.newDecryptorUnsafe((Key)publicKey));
    }

    @Override
    public SignatureBinary createSignature(byte[] data) {
        return new SignatureGeneric(data);
    }

    @Override
    public SignatureProcessorFactory<SignatureBinary, PR, PU> getSignatureFactoryWithoutHash() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.hashFactory.toString() + "+" + this.cryptorFactory.toString();
    }
}

